/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.modcluster;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.modcluster.CustomLoadMetricDefinition;
import org.jboss.as.modcluster.ModClusterExtension;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class ModClusterRemoveCustomMetric
implements OperationStepHandler {
    static final ModClusterRemoveCustomMetric INSTANCE = new ModClusterRemoveCustomMetric();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress parent = PathAddress.pathAddress((PathElement[])new PathElement[]{ModClusterExtension.SUBSYSTEM_PATH, ModClusterExtension.CONFIGURATION_PATH, ModClusterExtension.DYNAMIC_LOAD_PROVIDER});
        String clazz = CustomLoadMetricDefinition.CLASS.resolveModelAttribute(context, operation).asString();
        String name = this.getMetricName(context, clazz);
        if (name == null) {
            context.setRollbackOnly();
            return;
        }
        ModelNode targetOperation = Util.createRemoveOperation((PathAddress)parent.append(new PathElement[]{PathElement.pathElement((String)ModClusterExtension.CUSTOM_LOAD_METRIC.getKey(), (String)name)}));
        context.addStep(targetOperation, (OperationStepHandler)new ReloadRequiredRemoveStepHandler(), OperationContext.Stage.IMMEDIATE);
        context.completeStep();
    }

    private String getMetricName(OperationContext context, String clazz) {
        ModelNode loadProvider = context.readResource(PathAddress.pathAddress((PathElement[])new PathElement[]{ModClusterExtension.DYNAMIC_LOAD_PROVIDER})).getModel();
        ModelNode loadMetrics = loadProvider.get("custom-load-metric");
        for (Property p : loadMetrics.asPropertyList()) {
            String metricClass = p.getValue().get("type").asString();
            if (!metricClass.equals(clazz)) continue;
            return p.getName();
        }
        return null;
    }
}

