/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming;

import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.jboss.as.naming.util.NamingUtils;

public class ReadOnlyContext
implements Context {
    private final Context realContext;
    private final Hashtable<String, Object> environment;

    public ReadOnlyContext(Context realContext) throws NamingException {
        this.realContext = realContext;
        this.environment = NamingUtils.clone(realContext.getEnvironment());
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.realContext.lookup(name);
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.realContext.lookup(name);
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        throw new UnsupportedOperationException("Binding is not supported in a read-only context");
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        throw new UnsupportedOperationException("Binding is not supported in a read-only context");
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        throw new UnsupportedOperationException("Rebinding is not supported in a read-only context");
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        throw new UnsupportedOperationException("Rebinding is not supported in a read-only context");
    }

    @Override
    public void unbind(Name name) throws NamingException {
        throw new UnsupportedOperationException("Unbinding is not supported in a read-only context");
    }

    @Override
    public void unbind(String name) throws NamingException {
        throw new UnsupportedOperationException("Unbinding is not supported in a read-only context");
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        throw new UnsupportedOperationException("Renaming is not supported in a read-only context");
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        throw new UnsupportedOperationException("Renaming is not supported in a read-only context");
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.realContext.list(name);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        return this.realContext.list(name);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.realContext.listBindings(name);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return this.realContext.listBindings(name);
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        throw new UnsupportedOperationException("Destroying sub-contexts is not supported in a read-only context");
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        throw new UnsupportedOperationException("Destroying sub-contexts is not supported in a read-only context");
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        throw new UnsupportedOperationException("Creating sub-contexts is not supported in a read-only context");
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        throw new UnsupportedOperationException("Creating sub-contexts is not supported in a read-only context");
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.realContext.lookupLink(name);
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.realContext.lookupLink(name);
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.realContext.getNameParser(name);
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return this.realContext.getNameParser(name);
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        return this.realContext.composeName(name, prefix);
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return this.composeName(name, prefix);
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        throw new UnsupportedOperationException("Adding environment entries is not allowed in a read-only context");
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        throw new UnsupportedOperationException("Removing environment entries is not allowed in a read-only context");
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return this.environment;
    }

    @Override
    public void close() throws NamingException {
        throw new UnsupportedOperationException("Closing is not allowed in a read-only context");
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.realContext.getNameInNamespace();
    }
}

