/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.service;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Proxy;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.jboss.as.naming.service.JndiViewMBean;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class JndiView
implements JndiViewMBean,
Service<JndiView> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.naming");
    private static final String OBJECT_NAME = "jboss:type=JNDIView";
    private final InjectedValue<MBeanServer> mbeanServerValue = new InjectedValue();

    public synchronized void start(StartContext context) throws StartException {
        MBeanServer mbeanServer = this.getMbeanServer();
        try {
            mbeanServer.registerMBean(this, new ObjectName(OBJECT_NAME));
        }
        catch (Exception e) {
            throw new StartException("Failed to register JndiView mbean.", (Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        MBeanServer mbeanServer = this.getMbeanServer();
        try {
            mbeanServer.unregisterMBean(new ObjectName(OBJECT_NAME));
        }
        catch (Exception e) {
            log.error((Object)"Failed to unregister JndiView mbean", (Throwable)e);
        }
    }

    public JndiView getValue() throws IllegalStateException {
        return this;
    }

    public Injector<MBeanServer> getMBeanServerInjector() {
        return this.mbeanServerValue;
    }

    @Override
    public String list(boolean verbose) {
        StringBuffer buffer = new StringBuffer(4096);
        Context context = null;
        try {
            context = new InitialContext();
            context = (Context)context.lookup("java:");
            buffer.append("<h1>java: Namespace</h1>\n");
            buffer.append("<pre>\n");
            this.list(context, " ", buffer, verbose);
            buffer.append("</pre>\n");
        }
        catch (NamingException e) {
            log.error((Object)"lookup for java: failed", (Throwable)e);
            buffer.append("Failed to get InitialContext, ").append(e.toString(true));
            this.formatException(buffer, e);
        }
        try {
            context = new InitialContext();
            buffer.append("<h1>Global JNDI Namespace</h1>\n");
            buffer.append("<pre>\n");
            this.list(context, " ", buffer, verbose);
            buffer.append("</pre>\n");
        }
        catch (NamingException e) {
            log.error((Object)"Failed to get InitialContext", (Throwable)e);
            buffer.append("Failed to get InitialContext, ").append(e.toString(true));
            this.formatException(buffer, e);
        }
        return buffer.toString();
    }

    @Override
    public String listXML() {
        StringBuffer buffer = new StringBuffer(4096);
        Context context = null;
        this.openJndiTag(buffer);
        try {
            context = new InitialContext();
            context = (Context)context.lookup("java:");
        }
        catch (NamingException e) {
            log.error((Object)"Failed to get InitialContext for (java:)", (Throwable)e);
            this.appendErrorTag(buffer, "Failed to get InitialContext for (java:), " + e.toString(true));
        }
        if (context != null) {
            this.openContextTag(buffer);
            this.appendJavaNameTag(buffer);
            try {
                this.listXML(context, buffer);
            }
            catch (Throwable t) {
                log.error((Object)"Failed to list contents of (java:)", t);
                this.appendErrorTag(buffer, "Failed to list contents of (java:), " + t.toString());
            }
            this.closeContextTag(buffer);
        }
        try {
            context = new InitialContext();
        }
        catch (NamingException e) {
            log.error((Object)"Failed to get InitialContext", (Throwable)e);
            this.appendErrorTag(buffer, "Failed to get InitialContext, " + e.toString(true));
        }
        if (context != null) {
            this.openContextTag(buffer);
            this.appendGlobalNameTag(buffer);
            try {
                this.listXML(context, buffer);
            }
            catch (Throwable t) {
                log.error((Object)"Failed to list global contents ", t);
                this.appendErrorTag(buffer, "Failed to list global contents, " + t.toString());
            }
            this.closeContextTag(buffer);
        }
        this.closeJndiTag(buffer);
        return buffer.toString();
    }

    private void list(Context ctx, String indent, StringBuffer buffer, boolean verbose) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            NamingEnumeration<NameClassPair> ne = ctx.list("");
            while (ne.hasMore()) {
                Class<?> c;
                boolean isProxy;
                boolean isLinkRef;
                boolean recursive;
                String className;
                String name;
                NameClassPair pair;
                block21: {
                    pair = ne.next();
                    log.trace((Object)("pair: " + pair));
                    name = pair.getName();
                    className = pair.getClassName();
                    recursive = false;
                    isLinkRef = false;
                    isProxy = false;
                    c = null;
                    try {
                        c = loader.loadClass(className);
                        log.trace((Object)("type: " + c));
                        if (Context.class.isAssignableFrom(c)) {
                            recursive = true;
                        }
                        if (LinkRef.class.isAssignableFrom(c)) {
                            isLinkRef = true;
                        }
                        isProxy = Proxy.isProxyClass(c);
                    }
                    catch (ClassNotFoundException cnfe) {
                        if (!className.startsWith("$Proxy")) break block21;
                        isProxy = true;
                        try {
                            Object p = ctx.lookup(name);
                            c = p.getClass();
                        }
                        catch (NamingException e) {
                            String msg;
                            Throwable t = e.getRootCause();
                            if (!(t instanceof ClassNotFoundException) || (msg = t.getMessage()) == null) break block21;
                            className = msg;
                        }
                    }
                }
                buffer.append(indent).append(" +- ").append(name);
                if (isLinkRef) {
                    try {
                        log.trace((Object)("looking up LinkRef; name=" + name));
                        Object obj = ctx.lookupLink(name);
                        log.trace((Object)("Object type: " + obj.getClass()));
                        LinkRef link = (LinkRef)obj;
                        buffer.append("[link -> ");
                        buffer.append(link.getLinkName());
                        buffer.append(']');
                    }
                    catch (Throwable t) {
                        log.debug((Object)("Invalid LinkRef for: " + name), t);
                        buffer.append("invalid]");
                    }
                }
                if (isProxy) {
                    buffer.append(" (proxy: ").append(pair.getClassName());
                    if (c != null) {
                        Class<?>[] ifaces = c.getInterfaces();
                        buffer.append(" implements ");
                        for (Class<?> iface : ifaces) {
                            buffer.append(iface);
                            buffer.append(',');
                        }
                        buffer.setCharAt(buffer.length() - 1, ')');
                    } else {
                        buffer.append(" implements ").append(className).append(")");
                    }
                } else if (verbose) {
                    buffer.append(" (class: ").append(pair.getClassName()).append(")");
                }
                buffer.append('\n');
                if (!recursive) continue;
                try {
                    Object value = ctx.lookup(name);
                    if (value instanceof Context) {
                        Context subctx = (Context)value;
                        this.list(subctx, indent + " |  ", buffer, verbose);
                        continue;
                    }
                    buffer.append(indent).append(" |   NonContext: ").append(value);
                    buffer.append('\n');
                }
                catch (Throwable t) {
                    buffer.append("Failed to lookup: ").append(name).append(", errmsg=").append(t.getMessage());
                    buffer.append('\n');
                }
            }
            ne.close();
        }
        catch (NamingException ne) {
            buffer.append("error while listing context ").append(ctx.toString()).append(": ").append(ne.toString(true));
            this.formatException(buffer, ne);
        }
    }

    private void listXML(Context ctx, StringBuffer buffer) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            NamingEnumeration<NameClassPair> ne = ctx.list("");
            while (ne.hasMore()) {
                NameClassPair pair = ne.next();
                boolean recursive = false;
                boolean isLinkRef = false;
                try {
                    Class<?> c = loader.loadClass(pair.getClassName());
                    if (Context.class.isAssignableFrom(c)) {
                        recursive = true;
                    }
                    if (LinkRef.class.isAssignableFrom(c)) {
                        isLinkRef = true;
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    // empty catch block
                }
                String name = pair.getName();
                if (isLinkRef) {
                    Object obj = null;
                    LinkRef link = null;
                    try {
                        obj = ctx.lookupLink(name);
                        link = (LinkRef)obj;
                    }
                    catch (Throwable t) {
                        log.error((Object)("Invalid LinkRef for: " + name), t);
                        this.appendLinkRefErrorTag(buffer);
                    }
                    this.appendLinkRefTag(buffer, link, pair);
                    continue;
                }
                if (recursive) {
                    Object value = null;
                    try {
                        value = ctx.lookup(name);
                    }
                    catch (Throwable t) {
                        this.appendErrorTag(buffer, "Failed to lookup: " + name + ", errmsg=" + t.getMessage());
                    }
                    if (value instanceof Context) {
                        Context subctx = (Context)value;
                        this.openContextTag(buffer);
                        this.appendNCPTag(buffer, pair);
                        try {
                            this.listXML(subctx, buffer);
                        }
                        catch (Throwable t) {
                            this.appendErrorTag(buffer, "Failed to list contents of: " + name + ", errmsg=" + t.getMessage());
                        }
                        this.closeContextTag(buffer);
                        continue;
                    }
                    this.appendNonContextTag(buffer, pair);
                    continue;
                }
                this.appendLeafTag(buffer, pair);
            }
            ne.close();
        }
        catch (NamingException ne) {
            this.appendErrorTag(buffer, "error while listing context " + ctx.toString() + ": " + ne.toString(true));
        }
    }

    private void openJndiTag(StringBuffer buffer) {
        buffer.append("<jndi>\n");
    }

    private void closeJndiTag(StringBuffer buffer) {
        buffer.append("</jndi>\n");
    }

    private void appendPreExceptionTag(StringBuffer buffer, String msg, Throwable t) {
        buffer.append("<pre>\n").append(msg).append("\n");
        this.formatException(buffer, t);
        buffer.append("</pre>\n");
    }

    private void appendBeanTag(StringBuffer buffer, String bean) {
        buffer.append("<name>java:comp</name>\n");
        buffer.append("<attribute name='bean'>").append(bean).append("</attribute>\n");
    }

    private void appendJavaNameTag(StringBuffer buffer) {
        buffer.append("<name>java:</name>\n");
    }

    private void appendGlobalNameTag(StringBuffer buffer) {
        buffer.append("<name>Global</name>\n");
    }

    private void appendLinkRefTag(StringBuffer buffer, LinkRef link, NameClassPair ncp) {
        buffer.append("<link-ref>\n");
        buffer.append("<name>").append(ncp.getName()).append("</name>\n");
        try {
            String lName = link.getLinkName();
            buffer.append("<link>").append(lName).append("</link>\n");
        }
        catch (NamingException e) {
            this.appendErrorTag(buffer, "Failed to getLinkName, " + e.toString(true));
        }
        buffer.append("<attribute name='class'>").append(ncp.getClassName()).append("</attribute>\n");
        buffer.append("</link-ref>\n");
    }

    private void appendLinkRefErrorTag(StringBuffer buffer) {
        buffer.append("<link-ref>\n");
        buffer.append("<name>Invalid</name>\n");
        buffer.append("</link-ref>\n");
    }

    private void openContextTag(StringBuffer buffer) {
        buffer.append("<context>\n");
    }

    private void closeContextTag(StringBuffer buffer) {
        buffer.append("</context>\n");
    }

    private void appendNonContextTag(StringBuffer buffer, NameClassPair ncp) {
        buffer.append("<non-context>\n");
        this.appendNCPTag(buffer, ncp);
        buffer.append("</non-context>\n");
    }

    private void appendLeafTag(StringBuffer buffer, NameClassPair ncp) {
        buffer.append("<leaf>\n");
        this.appendNCPTag(buffer, ncp);
        buffer.append("</leaf>\n");
    }

    private void appendNCPTag(StringBuffer buffer, NameClassPair ncp) {
        buffer.append("<name>").append(ncp.getName()).append("</name>\n");
        buffer.append("<attribute name='class'>").append(ncp.getClassName()).append("</attribute>\n");
    }

    private void appendErrorTag(StringBuffer buffer, String msg) {
        buffer.append("<error>\n");
        buffer.append("<message>").append(msg).append("</message>\n");
        buffer.append("</error>\n");
    }

    private void formatException(StringBuffer buffer, Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        buffer.append("<pre>\n");
        t.printStackTrace(pw);
        buffer.append(sw.toString());
        buffer.append("</pre>\n");
    }

    private MBeanServer getMbeanServer() {
        MBeanServer mbeanServer = (MBeanServer)this.mbeanServerValue.getOptionalValue();
        if (mbeanServer == null) {
            mbeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        return mbeanServer;
    }
}

