/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Iterator;
import javax.naming.CannotProceedException;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.Reference;
import javax.naming.Referenceable;

public class NamingUtils {
    private static final Name EMPTY_NAME = new CompositeName();
    private static final Method CLONE = AccessController.doPrivileged(new PrivilegedAction<Method>(){

        @Override
        public Method run() {
            Method method;
            try {
                method = Object.class.getDeclaredMethod("clone", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException(e);
            }
            method.setAccessible(true);
            return method;
        }
    });

    private NamingUtils() {
    }

    public static String getLastComponent(Name name) {
        if (name.size() > 0) {
            return name.get(name.size() - 1);
        }
        return "";
    }

    public static boolean isEmpty(Name name) {
        return name.isEmpty() || name.size() == 1 && "".equals(name.get(0));
    }

    public static boolean isLastComponentEmpty(Name name) {
        return name.isEmpty() || NamingUtils.getLastComponent(name).equals("");
    }

    public static NameNotFoundException nameNotFoundException(String name, Name contextName) {
        return new NameNotFoundException(String.format("Name '%s' not found in context '%s'", name, contextName.toString()));
    }

    public static NameAlreadyBoundException nameAlreadyBoundException(Name name) throws NameAlreadyBoundException {
        throw new NameAlreadyBoundException(name.toString());
    }

    public static InvalidNameException emptyNameException() {
        return new InvalidNameException("An empty name is not allowed");
    }

    public static NotContextException notAContextException(Name name) {
        return new NotContextException(name.toString());
    }

    public static NamingException namingException(String message, Throwable cause) {
        NamingException exception = new NamingException(message);
        exception.setRootCause(cause);
        return exception;
    }

    public static NamingException namingException(String message, Throwable cause, Name remainingName) {
        NamingException exception = NamingUtils.namingException(message, cause);
        exception.setRemainingName(remainingName);
        return exception;
    }

    public static CannotProceedException cannotProceedException(Object resolvedObject, Name remainingName) {
        CannotProceedException cpe = new CannotProceedException();
        cpe.setResolvedObj(resolvedObject);
        cpe.setRemainingName(remainingName);
        return cpe;
    }

    public static Name emptyName() {
        return (Name)NamingUtils.cast(EMPTY_NAME.clone());
    }

    public static <T> NamingEnumeration<T> namingEnumeration(Collection<T> collection) {
        final Iterator<T> iterator = collection.iterator();
        return new NamingEnumeration<T>(){

            @Override
            public T next() {
                return this.nextElement();
            }

            @Override
            public boolean hasMore() {
                return this.hasMoreElements();
            }

            @Override
            public void close() {
            }

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public T nextElement() {
                return iterator.next();
            }
        };
    }

    public static <T extends Cloneable> T clone(T object) throws NamingException {
        if (object == null) {
            return null;
        }
        try {
            return (T)((Cloneable)CLONE.invoke(object, new Object[0]));
        }
        catch (IllegalAccessException e) {
            throw NamingUtils.namingException("Failed to clone " + object, e);
        }
        catch (InvocationTargetException e) {
            throw NamingUtils.namingException("Failed to clone " + object, e);
        }
    }

    public static <T> T cast(Object object) {
        return (T)object;
    }

    public static Reference asReference(Object object) {
        Reference reference = (Reference)NamingUtils.cast(object);
        return reference;
    }

    public static Referenceable asReferenceable(Object object) {
        Referenceable referenceable = (Referenceable)NamingUtils.cast(object);
        return referenceable;
    }
}

