/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.jboss.as.naming.NamingContext;
import org.jboss.as.naming.util.NamingUtils;
import org.jboss.as.naming.util.ThreadLocalStack;

public class MockContext
implements Context {
    private final NamingContext readContext;
    private final Name prefix;
    public static ThreadLocalStack<BindingTrap> bindingTraps = new ThreadLocalStack();

    public MockContext(NamingContext readContext, Name prefix) {
        this.readContext = readContext;
        this.prefix = prefix;
    }

    @Override
    public void bind(Name name, Object value) throws NamingException {
        String bindName = this.getAbsoluteName(name).toString();
        BindingTrap trap = bindingTraps.peek();
        if (trap == null) {
            throw new IllegalStateException("Nothing available to bind to.");
        }
        trap.bindings.put(bindName, value);
    }

    @Override
    public void bind(String name, Object value) throws NamingException {
        this.bind(this.parseName(name), value);
    }

    @Override
    public void rebind(Name name, Object value) throws NamingException {
        this.bind(name, value);
    }

    @Override
    public void rebind(String name, Object value) throws NamingException {
        this.rebind(this.parseName(name), value);
    }

    @Override
    public void unbind(Name name) throws NamingException {
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.unbind(this.parseName(name));
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        Object value;
        String absolute = this.getAbsoluteName(oldName).toString();
        String newAbsolute = this.getAbsoluteName(newName).toString();
        BindingTrap trap = bindingTraps.peek();
        if (trap != null) {
            value = trap.bindings.remove(absolute);
            if (value == null) {
                throw NamingUtils.nameNotFoundException(oldName.toString(), this.prefix);
            }
        } else {
            throw new IllegalStateException("Nothing available to bind to.");
        }
        trap.bindings.put(newAbsolute, value);
    }

    @Override
    public void rename(String s, String s1) throws NamingException {
        this.rebind(this.parseName(s), (Object)this.parseName(s1));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
    }

    @Override
    public void destroySubcontext(String s) throws NamingException {
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        Name prefix = this.composeName(name, this.prefix);
        NamingContext context = new NamingContext(prefix, this.readContext.getNamingStore(), null);
        return new MockContext(context, prefix);
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(this.parseName(name));
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        Object value = this.readContext.lookup(name);
        if (value instanceof NamingContext) {
            NamingContext context = (NamingContext)NamingContext.class.cast(value);
            Name prefix = context.getPrefix();
            return new MockContext(context, prefix);
        }
        return value;
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.lookup(this.parseName(name));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.readContext.list(name);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String s) throws NamingException {
        return this.readContext.list(s);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.readContext.listBindings(name);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String s) throws NamingException {
        return this.readContext.listBindings(s);
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.readContext.lookupLink(name);
    }

    @Override
    public Object lookupLink(String s) throws NamingException {
        return this.readContext.lookupLink(s);
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.readContext.getNameParser(name);
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return this.readContext.getNameParser(name);
    }

    @Override
    public Name composeName(Name name, Name name1) throws NamingException {
        return this.readContext.composeName(name, name1);
    }

    @Override
    public String composeName(String s, String s1) throws NamingException {
        return this.readContext.composeName(s, s1);
    }

    @Override
    public Object addToEnvironment(String s, Object o) throws NamingException {
        return null;
    }

    @Override
    public Object removeFromEnvironment(String s) throws NamingException {
        return null;
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return this.readContext.getEnvironment();
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.prefix.toString();
    }

    protected Name parseName(String name) throws NamingException {
        return this.getNameParser(name).parse(name);
    }

    protected Name getAbsoluteName(Name name) throws NamingException {
        if (name.isEmpty()) {
            return this.composeName(name, this.prefix);
        }
        String firstComponent = name.get(0);
        if (firstComponent.startsWith("java:")) {
            String cleaned = firstComponent.substring(5);
            Name suffix = name.getSuffix(1);
            if (cleaned.isEmpty()) {
                return suffix;
            }
            return suffix.add(0, cleaned);
        }
        if (firstComponent.isEmpty()) {
            return name.getSuffix(1);
        }
        return this.composeName(name, this.prefix);
    }

    public static void pushBindingTrap() {
        BindingTrap trap = new BindingTrap();
        bindingTraps.push(trap);
    }

    public static Map<String, Object> popTrappedBindings() {
        BindingTrap trap = bindingTraps.pop();
        if (trap != null) {
            return trap.bindings;
        }
        return null;
    }

    public static class BindingTrap {
        private final Map<String, Object> bindings = new HashMap<String, Object>();
    }
}

