/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.deployment;

import org.jboss.as.naming.deployment.JndiName;
import org.jboss.msc.service.ServiceName;

public class ContextNames {
    public static final ServiceName NAMING = ServiceName.JBOSS.append(new String[]{"naming"});
    public static final ServiceName JAVA_CONTEXT_SERVICE_NAME = NAMING.append(new String[]{"context", "java"});
    public static final ServiceName COMPONENT_CONTEXT_SERVICE_NAME = JAVA_CONTEXT_SERVICE_NAME.append(new String[]{"comp"});
    public static final JndiName JAVA_CONTEXT_NAME = JndiName.of("java:");
    public static final JndiName JBOSS_CONTEXT_NAME = JndiName.of("java:jboss");
    public static final ServiceName JBOSS_CONTEXT_SERVICE_NAME = JAVA_CONTEXT_SERVICE_NAME.append(new String[]{"jboss"});
    public static final JndiName GLOBAL_CONTEXT_NAME = JndiName.of("java:global");
    public static final ServiceName GLOBAL_CONTEXT_SERVICE_NAME = JAVA_CONTEXT_SERVICE_NAME.append(new String[]{"global"});
    public static final JndiName APPLICATION_CONTEXT_NAME = JndiName.of("java:app");
    public static final ServiceName APPLICATION_CONTEXT_SERVICE_NAME = JAVA_CONTEXT_SERVICE_NAME.append(new String[]{"app"});
    public static final JndiName MODULE_CONTEXT_NAME = JndiName.of("java:module");
    public static final ServiceName MODULE_CONTEXT_SERVICE_NAME = JAVA_CONTEXT_SERVICE_NAME.append(new String[]{"module"});
    public static final JndiName COMPONENT_CONTEXT_NAME = JndiName.of("java:comp");

    public static ServiceName contextServiceNameOfComponent(String app, String module, String comp) {
        return COMPONENT_CONTEXT_SERVICE_NAME.append(new String[]{app, module, comp});
    }

    public static ServiceName contextServiceNameOfModule(String app, String module) {
        return MODULE_CONTEXT_SERVICE_NAME.append(new String[]{app, module});
    }

    public static ServiceName contextServiceNameOfApplication(String app) {
        return APPLICATION_CONTEXT_SERVICE_NAME.append(new String[]{app});
    }

    public static ServiceName serviceNameOfContext(String app, String module, String comp, String context) {
        if (context.startsWith("java:")) {
            String namespace;
            int i = context.indexOf(47);
            if (i == -1) {
                namespace = context.substring(5);
            } else {
                if (i == 5) {
                    return JAVA_CONTEXT_SERVICE_NAME.append(new String[]{context.substring(6)});
                }
                namespace = context.substring(5, i);
            }
            if (namespace.equals("global")) {
                return GLOBAL_CONTEXT_SERVICE_NAME.append(new String[]{context.substring(12)});
            }
            if (namespace.equals("jboss")) {
                return JBOSS_CONTEXT_SERVICE_NAME.append(new String[]{context.substring(11)});
            }
            if (namespace.equals("app")) {
                return ContextNames.contextServiceNameOfApplication(app).append(new String[]{context.substring(9)});
            }
            if (namespace.equals("module")) {
                return ContextNames.contextServiceNameOfModule(app, module).append(new String[]{context.substring(12)});
            }
            if (namespace.equals("comp")) {
                return ContextNames.contextServiceNameOfComponent(app, module, comp).append(new String[]{context.substring(10)});
            }
            return JAVA_CONTEXT_SERVICE_NAME.append(new String[]{context});
        }
        return null;
    }

    public static ServiceName serviceNameOfNamingStore(String app, String module, String comp, String context) {
        if (context.startsWith("java:")) {
            int i = context.indexOf(47);
            String namespace = i == -1 ? context.substring(5) : context.substring(5, i);
            if (namespace.equals("global")) {
                return GLOBAL_CONTEXT_SERVICE_NAME;
            }
            if (namespace.equals("jboss")) {
                return JBOSS_CONTEXT_SERVICE_NAME;
            }
            if (namespace.equals("app")) {
                return ContextNames.contextServiceNameOfApplication(app);
            }
            if (namespace.equals("module")) {
                return ContextNames.contextServiceNameOfModule(app, module);
            }
            if (namespace.equals("comp")) {
                return ContextNames.contextServiceNameOfComponent(app, module, comp);
            }
            return JAVA_CONTEXT_SERVICE_NAME;
        }
        return null;
    }

    public static ServiceName serviceNameOfEnvEntry(String app, String module, String comp, boolean useCompNamespace, String envEntryName) {
        if (envEntryName.startsWith("java:")) {
            if (useCompNamespace) {
                return ContextNames.serviceNameOfContext(app, module, comp, envEntryName);
            }
            if (envEntryName.startsWith("java:comp")) {
                return ContextNames.serviceNameOfContext(app, module, module, "java:module" + envEntryName.substring("java:comp".length()));
            }
            return ContextNames.serviceNameOfContext(app, module, module, envEntryName);
        }
        if (useCompNamespace) {
            return ContextNames.serviceNameOfContext(app, module, comp, "java:comp/env/" + envEntryName);
        }
        return ContextNames.serviceNameOfContext(app, module, module, "java:module/env/" + envEntryName);
    }
}

