/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.service;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.naming.InMemoryNamingStore;
import org.jboss.as.naming.InitialContextFactoryService;
import org.jboss.as.naming.NamingContext;
import org.jboss.as.naming.NamingEventCoordinator;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.deployment.JndiNamingDependencyProcessor;
import org.jboss.as.naming.deployment.JndiNamingDependencySetupProcessor;
import org.jboss.as.naming.management.JndiViewExtensionRegistry;
import org.jboss.as.naming.service.EEContextService;
import org.jboss.as.naming.service.GlobalContextService;
import org.jboss.as.naming.service.NamingService;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class NamingSubsystemAdd
extends AbstractAddStepHandler {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.naming");
    static final NamingSubsystemAdd INSTANCE = new NamingSubsystemAdd();

    protected void populateModel(ModelNode operation, ModelNode model) {
        model.setEmptyObject();
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        log.info((Object)"Activating Naming Subsystem");
        NamingContext.initializeNamingManager();
        InMemoryNamingStore namingStore = new InMemoryNamingStore(new NamingEventCoordinator());
        ServiceTarget target = context.getServiceTarget();
        newControllers.add(target.addService(NamingService.SERVICE_NAME, (Service)new NamingService(namingStore)).addAliases(new ServiceName[]{ContextNames.JAVA_CONTEXT_SERVICE_NAME}).setInitialMode(ServiceController.Mode.ACTIVE).addListener((ServiceListener)verificationHandler).install());
        newControllers.add(NamingSubsystemAdd.addGlobalContextFactory(target, "global", verificationHandler));
        newControllers.add(NamingSubsystemAdd.addGlobalContextFactory(target, "jboss", verificationHandler));
        newControllers.add(NamingSubsystemAdd.addContextFactory(target, "app", verificationHandler));
        newControllers.add(NamingSubsystemAdd.addContextFactory(target, "module", verificationHandler));
        newControllers.add(NamingSubsystemAdd.addContextFactory(target, "comp", verificationHandler));
        newControllers.add(InitialContextFactoryService.addService(target, verificationHandler));
        newControllers.add(target.addService(JndiViewExtensionRegistry.SERVICE_NAME, (Service)new JndiViewExtensionRegistry()).install());
        if (context.isBooting()) {
            context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

                protected void execute(DeploymentProcessorTarget processorTarget) {
                    processorTarget.addDeploymentProcessor(Phase.INSTALL, 256, (DeploymentUnitProcessor)new JndiNamingDependencySetupProcessor());
                    processorTarget.addDeploymentProcessor(Phase.INSTALL, 7169, (DeploymentUnitProcessor)new JndiNamingDependencyProcessor());
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    private static ServiceController<?> addContextFactory(ServiceTarget target, String contextName, ServiceVerificationHandler verificationHandler) {
        EEContextService eeContextService = new EEContextService(contextName);
        return target.addService(ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{contextName}), (Service)eeContextService).addDependency(ContextNames.JAVA_CONTEXT_SERVICE_NAME, NamingStore.class, eeContextService.getJavaContextInjector()).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    private static ServiceController<?> addGlobalContextFactory(ServiceTarget target, String contextName, ServiceVerificationHandler verificationHandler) {
        GlobalContextService eeContextService = new GlobalContextService(contextName);
        return target.addService(ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{contextName}), (Service)eeContextService).addDependency(ContextNames.JAVA_CONTEXT_SERVICE_NAME, NamingStore.class, eeContextService.getJavaContextInjector()).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }
}

