/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.deployment;

import org.jboss.as.naming.deployment.JndiName;
import org.jboss.msc.service.ServiceName;

public class ContextNames {
    public static final ServiceName NAMING = ServiceName.JBOSS.append(new String[]{"naming"});
    public static final ServiceName JAVA_CONTEXT_SERVICE_NAME = NAMING.append(new String[]{"context", "java"});
    public static final ServiceName COMPONENT_CONTEXT_SERVICE_NAME = JAVA_CONTEXT_SERVICE_NAME.append(new String[]{"comp"});
    private static final JndiName JAVA_CONTEXT_NAME = JndiName.of("java:");
    public static final JndiName JBOSS_CONTEXT_NAME = JndiName.of("java:jboss");
    public static final ServiceName JBOSS_CONTEXT_SERVICE_NAME = JAVA_CONTEXT_SERVICE_NAME.append(new String[]{"jboss"});
    public static final JndiName GLOBAL_CONTEXT_NAME = JndiName.of("java:global");
    public static final ServiceName GLOBAL_CONTEXT_SERVICE_NAME = JAVA_CONTEXT_SERVICE_NAME.append(new String[]{"global"});
    public static final JndiName APPLICATION_CONTEXT_NAME = JndiName.of("java:app");
    public static final ServiceName APPLICATION_CONTEXT_SERVICE_NAME = JAVA_CONTEXT_SERVICE_NAME.append(new String[]{"app"});
    public static final JndiName MODULE_CONTEXT_NAME = JndiName.of("java:module");
    public static final ServiceName MODULE_CONTEXT_SERVICE_NAME = JAVA_CONTEXT_SERVICE_NAME.append(new String[]{"module"});
    public static final JndiName COMPONENT_CONTEXT_NAME = JndiName.of("java:comp");

    public static ServiceName contextServiceNameOfComponent(String app, String module, String comp) {
        return COMPONENT_CONTEXT_SERVICE_NAME.append(new String[]{app, module, comp});
    }

    public static ServiceName contextServiceNameOfModule(String app, String module) {
        return MODULE_CONTEXT_SERVICE_NAME.append(new String[]{app, module});
    }

    public static ServiceName contextServiceNameOfApplication(String app) {
        return APPLICATION_CONTEXT_SERVICE_NAME.append(new String[]{app});
    }

    public static ServiceName serviceNameOfContext(String app, String module, String comp, String context) {
        if (context.startsWith("java:")) {
            String namespace;
            int i = context.indexOf(47);
            if (i == -1) {
                namespace = context.substring(5);
            } else {
                if (i == 5) {
                    return JAVA_CONTEXT_SERVICE_NAME.append(new String[]{context.substring(6)});
                }
                namespace = context.substring(5, i);
            }
            if (namespace.equals("global")) {
                return GLOBAL_CONTEXT_SERVICE_NAME.append(new String[]{context.substring(12)});
            }
            if (namespace.equals("jboss")) {
                return JBOSS_CONTEXT_SERVICE_NAME.append(new String[]{context.substring(11)});
            }
            if (namespace.equals("app")) {
                return ContextNames.contextServiceNameOfApplication(app).append(new String[]{context.substring(9)});
            }
            if (namespace.equals("module")) {
                return ContextNames.contextServiceNameOfModule(app, module).append(new String[]{context.substring(12)});
            }
            if (namespace.equals("comp")) {
                return ContextNames.contextServiceNameOfComponent(app, module, comp).append(new String[]{context.substring(10)});
            }
            return JBOSS_CONTEXT_SERVICE_NAME.append(new String[]{context});
        }
        return null;
    }

    public static ServiceName serviceNameOfGlobalEntry(String context) {
        if (context.startsWith("java:")) {
            String namespace;
            int i = context.indexOf(47);
            if (i == -1) {
                namespace = context.substring(5);
            } else {
                if (i == 5) {
                    return JAVA_CONTEXT_SERVICE_NAME.append(new String[]{context.substring(6)});
                }
                namespace = context.substring(5, i);
            }
            if (namespace.equals("global")) {
                return GLOBAL_CONTEXT_SERVICE_NAME.append(new String[]{context.substring(12)});
            }
            if (namespace.equals("jboss")) {
                return JBOSS_CONTEXT_SERVICE_NAME.append(new String[]{context.substring(11)});
            }
            if (namespace.equals("app")) {
                throw new RuntimeException("No java:app namespace is available for jndi entry " + context);
            }
            if (namespace.equals("module")) {
                throw new RuntimeException("No java:module namespace is available for jndi entry " + context);
            }
            if (namespace.equals("comp")) {
                throw new RuntimeException("No java:comp namespace is available for jndi entry " + context);
            }
            return JAVA_CONTEXT_SERVICE_NAME.append(new String[]{context});
        }
        return JAVA_CONTEXT_SERVICE_NAME.append(new String[]{context});
    }

    public static ServiceName serviceNameOfNamingStore(String app, String module, String comp, String context) {
        if (context.startsWith("java:")) {
            int i = context.indexOf(47);
            String namespace = i == -1 ? context.substring(5) : context.substring(5, i);
            if (namespace.equals("global")) {
                return GLOBAL_CONTEXT_SERVICE_NAME;
            }
            if (namespace.equals("jboss")) {
                return JBOSS_CONTEXT_SERVICE_NAME;
            }
            if (namespace.equals("app")) {
                return ContextNames.contextServiceNameOfApplication(app);
            }
            if (namespace.equals("module")) {
                return ContextNames.contextServiceNameOfModule(app, module);
            }
            if (namespace.equals("comp")) {
                return ContextNames.contextServiceNameOfComponent(app, module, comp);
            }
            return JBOSS_CONTEXT_SERVICE_NAME;
        }
        return null;
    }

    public static ServiceName serviceNameOfEnvEntry(String app, String module, String comp, boolean useCompNamespace, String envEntryName) {
        if (envEntryName.startsWith("java:")) {
            if (useCompNamespace) {
                return ContextNames.serviceNameOfContext(app, module, comp, envEntryName);
            }
            if (envEntryName.startsWith("java:comp")) {
                return ContextNames.serviceNameOfContext(app, module, module, "java:module" + envEntryName.substring("java:comp".length()));
            }
            return ContextNames.serviceNameOfContext(app, module, module, envEntryName);
        }
        if (useCompNamespace) {
            return ContextNames.serviceNameOfContext(app, module, comp, "java:comp/env/" + envEntryName);
        }
        return ContextNames.serviceNameOfContext(app, module, module, "java:module/env/" + envEntryName);
    }

    public static BindInfo bindInfoFor(String jndiName) {
        ServiceName parentContextName;
        String bindName = jndiName.startsWith("java:") ? jndiName.substring(5) : (!jndiName.startsWith("/") ? "/" + jndiName : jndiName);
        if (bindName.startsWith("jboss/")) {
            parentContextName = JBOSS_CONTEXT_SERVICE_NAME;
            bindName = bindName.substring(6);
        } else if (bindName.startsWith("global/")) {
            parentContextName = GLOBAL_CONTEXT_SERVICE_NAME;
            bindName = bindName.substring(6);
        } else if (bindName.startsWith("/")) {
            parentContextName = JAVA_CONTEXT_SERVICE_NAME;
            bindName = bindName.substring(1);
        } else {
            throw new RuntimeException("Illegal context in name: " + jndiName);
        }
        return new BindInfo(parentContextName, bindName);
    }

    public static class BindInfo {
        private final ServiceName parentContextServiceName;
        private final ServiceName binderServiceName;
        private final String bindName;
        private final String absoluteJndiName;

        private BindInfo(ServiceName parentContextServiceName, String bindName) {
            this.parentContextServiceName = parentContextServiceName;
            this.binderServiceName = parentContextServiceName.append(new String[]{bindName});
            this.bindName = bindName;
            this.absoluteJndiName = this.generateAbsoluteJndiName();
        }

        public ServiceName getParentContextServiceName() {
            return this.parentContextServiceName;
        }

        public ServiceName getBinderServiceName() {
            return this.binderServiceName;
        }

        public String getBindName() {
            return this.bindName;
        }

        public String getAbsoluteJndiName() {
            return this.absoluteJndiName;
        }

        public String toString() {
            return "BindInfo{parentContextServiceName=" + this.parentContextServiceName + ", binderServiceName=" + this.binderServiceName + ", bindName='" + this.bindName + '\'' + '}';
        }

        private String generateAbsoluteJndiName() {
            StringBuffer sb = new StringBuffer();
            if (this.parentContextServiceName.equals(JBOSS_CONTEXT_SERVICE_NAME)) {
                sb.append("java:jboss/");
            } else if (this.parentContextServiceName.equals((Object)APPLICATION_CONTEXT_NAME)) {
                sb.append("java:app/");
            } else if (this.parentContextServiceName.equals(MODULE_CONTEXT_SERVICE_NAME)) {
                sb.append("java:module/");
            } else if (this.parentContextServiceName.equals(COMPONENT_CONTEXT_SERVICE_NAME)) {
                sb.append("java:comp/");
            } else if (this.parentContextServiceName.equals(GLOBAL_CONTEXT_SERVICE_NAME)) {
                sb.append("java:global/");
            } else if (this.parentContextServiceName.equals(JAVA_CONTEXT_SERVICE_NAME)) {
                sb.append("java:/");
            }
            sb.append(this.bindName);
            return sb.toString();
        }
    }
}

