/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.service;

import javax.naming.NamingException;
import org.jboss.as.naming.InMemoryNamingStore;
import org.jboss.as.naming.NamingStore;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class NamingStoreService
implements Service<NamingStore> {
    private NamingStore store;

    public NamingStoreService() {
    }

    public NamingStoreService(NamingStore store) {
        this.store = store;
    }

    public synchronized void start(StartContext context) throws StartException {
        if (this.store == null) {
            this.store = new InMemoryNamingStore();
        }
    }

    public synchronized void stop(StopContext context) {
        try {
            this.store.close();
            this.store = null;
        }
        catch (NamingException e) {
            throw new IllegalStateException("Failed to destroy naming store", e);
        }
    }

    public synchronized NamingStore getValue() throws IllegalStateException {
        return this.store;
    }
}

