/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import org.jboss.as.naming.NamingContext;
import org.jboss.as.naming.NamingMessages;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.naming.WritableNamingStore;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.naming.util.NamingUtils;
import org.jboss.as.naming.util.ThreadLocalStack;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

public class WritableServiceBasedNamingStore
extends ServiceBasedNamingStore
implements WritableNamingStore {
    private static final ThreadLocalStack<WriteOwner> WRITE_OWNER = new ThreadLocalStack();

    public WritableServiceBasedNamingStore(ServiceRegistry serviceRegistry, ServiceName serviceNameBase) {
        super(serviceRegistry, serviceNameBase);
    }

    @Override
    public void bind(Name name, Object object) throws NamingException {
        WriteOwner owner = this.requireOwner();
        ServiceName bindName = this.buildServiceName(name);
        BindListener listener = new BindListener();
        BinderService binderService = new BinderService(name.toString());
        ServiceBuilder builder = owner.target.addService(bindName, (Service)binderService).addDependency(this.getServiceNameBase(), ServiceBasedNamingStore.class, binderService.getNamingStoreInjector()).addInjection(binderService.getManagedObjectInjector(), (Object)new ValueManagedReferenceFactory((Value<?>)new ImmediateValue(object))).setInitialMode(ServiceController.Mode.ACTIVE).addListener((ServiceListener)listener);
        for (ServiceName dependency : owner.dependencies) {
            builder.addDependency(dependency);
        }
        builder.install();
        try {
            listener.await();
        }
        catch (Exception e) {
            throw NamingUtils.namingException("Failed to bind [" + object + "] at location [" + bindName + "]", e);
        }
    }

    @Override
    public void bind(Name name, Object object, Class<?> bindType) throws NamingException {
        this.bind(name, object);
    }

    @Override
    public void rebind(Name name, Object object) throws NamingException {
        this.unbind(name);
        this.bind(name, object);
    }

    @Override
    public void rebind(Name name, Object object, Class<?> bindType) throws NamingException {
        this.rebind(name, object);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.requireOwner();
        ServiceName bindName = this.buildServiceName(name);
        ServiceController controller = this.getServiceRegistry().getService(bindName);
        if (controller == null) {
            throw NamingMessages.MESSAGES.cannotResolveService(bindName);
        }
        UnbindListener listener = new UnbindListener();
        controller.addListener((ServiceListener)listener);
        try {
            listener.await();
        }
        catch (Exception e) {
            throw NamingUtils.namingException("Failed to unbind [" + bindName + "]", e);
        }
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        this.requireOwner();
        if (NamingUtils.isLastComponentEmpty(name)) {
            throw NamingMessages.MESSAGES.emptyNameNotAllowed();
        }
        return new NamingContext(name, this, new Hashtable<String, Object>());
    }

    private WriteOwner requireOwner() {
        WriteOwner owner = WRITE_OWNER.peek();
        if (owner == null) {
            throw NamingMessages.MESSAGES.readOnlyNamingContext();
        }
        return owner;
    }

    public static void pushOwner(ServiceTarget target, ServiceName ... dependencies) {
        WRITE_OWNER.push(new WriteOwner(target, dependencies));
    }

    public static void popOwner() {
        WRITE_OWNER.pop();
    }

    private static class WriteOwner {
        private final ServiceTarget target;
        private final ServiceName[] dependencies;

        public WriteOwner(ServiceTarget target, ServiceName ... dependencies) {
            this.target = target;
            this.dependencies = dependencies;
        }
    }

    private class UnbindListener
    extends AbstractServiceListener<Object> {
        private boolean complete;

        private UnbindListener() {
        }

        public void listenerAdded(ServiceController<?> controller) {
            controller.setMode(ServiceController.Mode.REMOVE);
        }

        public synchronized void transition(ServiceController<? extends Object> serviceController, ServiceController.Transition transition) {
            switch (transition) {
                case REMOVING_to_REMOVED: {
                    this.complete = true;
                    ((Object)((Object)this)).notifyAll();
                }
            }
        }

        public synchronized void await() throws Exception {
            while (!this.complete) {
                ((Object)((Object)this)).wait();
            }
        }
    }

    private class BindListener
    extends AbstractServiceListener<Object> {
        private Exception exception;
        private boolean complete;

        private BindListener() {
        }

        public synchronized void transition(ServiceController<? extends Object> serviceController, ServiceController.Transition transition) {
            switch (transition) {
                case STARTING_to_UP: {
                    this.complete = true;
                    ((Object)((Object)this)).notifyAll();
                    break;
                }
                case STARTING_to_START_FAILED: {
                    this.complete = true;
                    this.exception = serviceController.getStartException();
                    ((Object)((Object)this)).notifyAll();
                }
            }
        }

        public synchronized void await() throws Exception {
            while (!this.complete) {
                ((Object)((Object)this)).wait();
            }
            if (this.exception != null) {
                throw this.exception;
            }
        }
    }
}

