/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming;

import java.util.Arrays;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CannotProceedException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.event.EventContext;
import javax.naming.event.NamingListener;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.ResolveResult;
import org.jboss.as.naming.InMemoryNamingStore;
import org.jboss.as.naming.InitialContextFactoryBuilder;
import org.jboss.as.naming.JndiPermission;
import org.jboss.as.naming.NamingLogger;
import org.jboss.as.naming.NamingMessages;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.RequireResolveException;
import org.jboss.as.naming.SecurityActions;
import org.jboss.as.naming.WritableNamingStore;
import org.jboss.as.naming.context.ObjectFactoryBuilder;
import org.jboss.as.naming.util.NameParser;
import org.jboss.as.naming.util.NamingUtils;

public class NamingContext
implements EventContext {
    private static NamingStore ACTIVE_NAMING_STORE = new InMemoryNamingStore();
    private static final String PACKAGE_PREFIXES = "org.jboss.as.naming.interfaces";
    private final NamingStore namingStore;
    private final Name prefix;
    private final Hashtable<String, Object> environment;

    public static void setActiveNamingStore(NamingStore namingStore) {
        ACTIVE_NAMING_STORE = namingStore;
    }

    public static void initializeNamingManager() {
        String property = SecurityActions.getSystemProperty("java.naming.factory.url.pkgs");
        if (property == null || property.isEmpty()) {
            SecurityActions.setSystemProperty("java.naming.factory.url.pkgs", PACKAGE_PREFIXES);
        } else if (!Arrays.asList(property.split(":")).contains(PACKAGE_PREFIXES)) {
            SecurityActions.setSystemProperty("java.naming.factory.url.pkgs", "org.jboss.as.naming.interfaces:" + property);
        }
        try {
            if (!NamingManager.hasInitialContextFactoryBuilder()) {
                NamingManager.setInitialContextFactoryBuilder(new InitialContextFactoryBuilder());
            }
        }
        catch (NamingException e) {
            NamingLogger.ROOT_LOGGER.failedToSet(e, "InitialContextFactoryBuilder");
        }
    }

    public NamingContext(Hashtable<String, Object> environment) {
        this(new CompositeName(), ACTIVE_NAMING_STORE, environment);
    }

    public NamingContext(Name prefix, Hashtable<String, Object> environment) throws NamingException {
        this(prefix, ACTIVE_NAMING_STORE, environment);
    }

    public NamingContext(Name prefix, NamingStore namingStore, Hashtable<String, Object> environment) {
        if (prefix == null) {
            throw NamingMessages.MESSAGES.nullVar("Naming prefix");
        }
        this.prefix = prefix;
        if (namingStore == null) {
            throw NamingMessages.MESSAGES.nullVar("NamingStore");
        }
        this.namingStore = namingStore;
        this.environment = environment != null ? new Hashtable<String, Object>(environment) : new Hashtable();
    }

    public NamingContext(NamingStore namingStore, Hashtable<String, Object> environment) {
        this(new CompositeName(), namingStore, environment);
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.lookup(name, true);
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.lookup(name, true);
    }

    public Object lookup(String name, boolean dereference) throws NamingException {
        return this.lookup(this.parseName(name), dereference);
    }

    public Object lookup(Name name, boolean dereference) throws NamingException {
        Object result;
        this.check(name, JndiPermission.Action.LOOKUP);
        if (NamingUtils.isEmpty(name)) {
            return new NamingContext(this.prefix, this.namingStore, this.environment);
        }
        Name absoluteName = this.getAbsoluteName(name);
        try {
            result = this.namingStore.lookup(absoluteName, dereference);
        }
        catch (CannotProceedException cpe) {
            Context continuationContext = NamingManager.getContinuationContext(cpe);
            result = continuationContext instanceof NamingContext ? ((NamingContext)continuationContext).lookup(cpe.getRemainingName(), dereference) : continuationContext.lookup(cpe.getRemainingName());
        }
        if (result instanceof ResolveResult) {
            ResolveResult resolveResult = (ResolveResult)result;
            Object resolvedObject = resolveResult.getResolvedObj();
            Object context = resolvedObject instanceof Context ? resolvedObject : (resolvedObject instanceof LinkRef ? this.resolveLink(resolvedObject, dereference) : this.getObjectInstance(resolvedObject, absoluteName, this.environment));
            if (!(context instanceof Context)) {
                throw NamingUtils.notAContextException(absoluteName.getPrefix(absoluteName.size() - resolveResult.getRemainingName().size()));
            }
            Context namingContext = (Context)context;
            if (namingContext instanceof NamingContext) {
                return ((NamingContext)namingContext).lookup(resolveResult.getRemainingName(), dereference);
            }
            return namingContext.lookup(resolveResult.getRemainingName());
        }
        if (result instanceof LinkRef) {
            result = this.resolveLink(result, dereference);
        } else if (result instanceof Reference && (result = this.getObjectInstance(result, absoluteName, this.environment)) instanceof LinkRef) {
            result = this.resolveLink(result, dereference);
        }
        return result;
    }

    @Override
    public void bind(Name name, Object object) throws NamingException {
        Name absoluteName;
        this.check(name, JndiPermission.Action.BIND);
        if (this.namingStore instanceof WritableNamingStore) {
            absoluteName = this.getAbsoluteName(name);
            if (object instanceof Referenceable) {
                object = ((Referenceable)object).getReference();
            }
        } else {
            throw NamingMessages.MESSAGES.readOnlyNamingContext();
        }
        this.getWritableNamingStore().bind(absoluteName, object);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.bind(this.parseName(name), obj);
    }

    @Override
    public void rebind(Name name, Object object) throws NamingException {
        Name absoluteName;
        this.check(name, JndiPermission.Action.REBIND);
        if (this.namingStore instanceof WritableNamingStore) {
            absoluteName = this.getAbsoluteName(name);
            if (object instanceof Referenceable) {
                object = ((Referenceable)object).getReference();
            }
        } else {
            throw NamingMessages.MESSAGES.readOnlyNamingContext();
        }
        this.getWritableNamingStore().rebind(absoluteName, object);
    }

    @Override
    public void rebind(String name, Object object) throws NamingException {
        this.rebind(this.parseName(name), object);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.check(name, JndiPermission.Action.UNBIND);
        if (!(this.namingStore instanceof WritableNamingStore)) {
            throw NamingMessages.MESSAGES.readOnlyNamingContext();
        }
        Name absoluteName = this.getAbsoluteName(name);
        this.getWritableNamingStore().unbind(absoluteName);
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.unbind(this.parseName(name));
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        this.check(oldName, JndiPermission.Action.LOOKUP, JndiPermission.Action.UNBIND);
        this.check(newName, JndiPermission.Action.BIND);
        if (!(this.namingStore instanceof WritableNamingStore)) {
            throw NamingMessages.MESSAGES.readOnlyNamingContext();
        }
        this.bind(newName, this.lookup(oldName));
        this.unbind(oldName);
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.rename(this.parseName(oldName), this.parseName(newName));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        this.check(name, JndiPermission.Action.LIST);
        try {
            return NamingUtils.namingEnumeration(this.namingStore.list(this.getAbsoluteName(name)));
        }
        catch (CannotProceedException cpe) {
            Context continuationContext = NamingManager.getContinuationContext(cpe);
            return continuationContext.list(cpe.getRemainingName());
        }
        catch (RequireResolveException r) {
            Object o = this.lookup(r.getResolve());
            if (o instanceof Context) {
                return ((Context)o).list(name.getSuffix(r.getResolve().size()));
            }
            throw NamingUtils.notAContextException(r.getResolve());
        }
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        return this.list(this.parseName(name));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        this.check(name, JndiPermission.Action.LIST_BINDINGS);
        try {
            return NamingUtils.namingEnumeration(this.namingStore.listBindings(this.getAbsoluteName(name)));
        }
        catch (CannotProceedException cpe) {
            Context continuationContext = NamingManager.getContinuationContext(cpe);
            return continuationContext.listBindings(cpe.getRemainingName());
        }
        catch (RequireResolveException r) {
            Object o = this.lookup(r.getResolve());
            if (o instanceof Context) {
                return ((Context)o).listBindings(name.getSuffix(r.getResolve().size()));
            }
            throw NamingUtils.notAContextException(r.getResolve());
        }
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return this.listBindings(this.parseName(name));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.check(name, JndiPermission.Action.DESTROY_SUBCONTEXT);
        if (!(this.namingStore instanceof WritableNamingStore)) {
            throw NamingMessages.MESSAGES.readOnlyNamingContext();
        }
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(this.parseName(name));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        this.check(name, JndiPermission.Action.CREATE_SUBCONTEXT);
        if (this.namingStore instanceof WritableNamingStore) {
            Name absoluteName = this.getAbsoluteName(name);
            return this.getWritableNamingStore().createSubcontext(absoluteName);
        }
        throw NamingMessages.MESSAGES.readOnlyNamingContext();
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(this.parseName(name));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        this.check(name, JndiPermission.Action.LOOKUP);
        if (name.isEmpty()) {
            return this.lookup(name);
        }
        try {
            Name absoluteName = this.getAbsoluteName(name);
            Object link = this.namingStore.lookup(absoluteName);
            if (!(link instanceof LinkRef) && link instanceof Reference) {
                link = this.getObjectInstance(link, name, null);
            }
            return link;
        }
        catch (Exception e) {
            throw NamingUtils.namingException(NamingMessages.MESSAGES.cannotLookupLink(), e, name);
        }
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookupLink(this.parseName(name));
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return NameParser.INSTANCE;
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return NameParser.INSTANCE;
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return this.composeName(this.parseName(name), this.parseName(prefix)).toString();
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        Object existing = this.environment.get(propName);
        this.environment.put(propName, propVal);
        return existing;
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.environment.remove(propName);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return this.environment;
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.prefix.toString();
    }

    @Override
    public void addNamingListener(Name target, int scope, NamingListener listener) throws NamingException {
        this.check(target, JndiPermission.Action.ADD_NAMING_LISTENER);
        this.namingStore.addNamingListener(target, scope, listener);
    }

    @Override
    public void addNamingListener(String target, int scope, NamingListener listener) throws NamingException {
        this.addNamingListener(this.parseName(target), scope, listener);
    }

    @Override
    public void removeNamingListener(NamingListener listener) throws NamingException {
        this.namingStore.removeNamingListener(listener);
    }

    @Override
    public boolean targetMustExist() throws NamingException {
        return false;
    }

    private Name parseName(String name) throws NamingException {
        return this.getNameParser(name).parse(name);
    }

    private Name getAbsoluteName(Name name) throws NamingException {
        if (name.isEmpty()) {
            return this.composeName(name, this.prefix);
        }
        String firstComponent = name.get(0);
        if (firstComponent.startsWith("java:")) {
            String cleaned = firstComponent.substring(5);
            Name suffix = name.getSuffix(1);
            if (cleaned.isEmpty()) {
                return suffix;
            }
            return suffix.add(0, cleaned);
        }
        if (firstComponent.isEmpty()) {
            return name.getSuffix(1);
        }
        return this.composeName(name, this.prefix);
    }

    private Object getObjectInstance(Object object, Name name, Hashtable<?, ?> environment) throws NamingException {
        try {
            ObjectFactoryBuilder factoryBuilder = ObjectFactoryBuilder.INSTANCE;
            ObjectFactory objectFactory = factoryBuilder.createObjectFactory(object, environment);
            return objectFactory.getObjectInstance(object, name, this, environment);
        }
        catch (NamingException e) {
            throw e;
        }
        catch (Throwable t) {
            throw NamingMessages.MESSAGES.cannotDeferenceObject(t);
        }
    }

    private Object resolveLink(Object result, boolean dereference) throws NamingException {
        Object linkResult;
        try {
            LinkRef linkRef = (LinkRef)result;
            String referenceName = linkRef.getLinkName();
            linkResult = referenceName.startsWith("./") ? this.lookup(this.parseName(referenceName.substring(2)), dereference) : new InitialContext().lookup(referenceName);
        }
        catch (Throwable t) {
            throw NamingMessages.MESSAGES.cannotDeferenceObject(t);
        }
        return linkResult;
    }

    private void check(Name name, JndiPermission.Action ... actions) throws NamingException {
        Name absoluteName = this.getAbsoluteName(name);
        JndiPermission.check(absoluteName, actions);
    }

    Name getPrefix() {
        return this.prefix;
    }

    NamingStore getNamingStore() {
        return this.namingStore;
    }

    WritableNamingStore getWritableNamingStore() {
        return (WritableNamingStore)WritableNamingStore.class.cast(this.getNamingStore());
    }

    static {
        try {
            NamingManager.setObjectFactoryBuilder(ObjectFactoryBuilder.INSTANCE);
        }
        catch (Throwable t) {
            NamingLogger.ROOT_LOGGER.failedToSet(t, "ObjectFactoryBuilder");
        }
    }
}

