/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.subsystem;

import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.naming.subsystem.NamingBindingResourceDefinition;
import org.jboss.as.naming.subsystem.NamingExtension;
import org.jboss.as.naming.subsystem.NamingSubsystemNamespace;
import org.jboss.as.naming.subsystem.NamingSubsystemXMLAttribute;
import org.jboss.as.naming.subsystem.NamingSubsystemXMLElement;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class NamingSubsystem13Parser
implements XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    public static final NamingSubsystem13Parser INSTANCE = new NamingSubsystem13Parser();

    private NamingSubsystem13Parser() {
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        ModelNode service;
        context.startSubsystemElement("urn:jboss:domain:naming:1.3", false);
        ModelNode model = context.getModelNode();
        if (model.hasDefined("binding")) {
            writer.writeStartElement(NamingSubsystemXMLElement.BINDINGS.getLocalName());
            ModelNode bindingModel = model.get("binding");
            this.writeBindings(writer, bindingModel);
            writer.writeEndElement();
        }
        if (model.hasDefined("service") && (service = model.get("service")).has("remote-naming")) {
            writer.writeEmptyElement("remote-naming");
        }
        writer.writeEndElement();
    }

    private void writeBindings(XMLExtendedStreamWriter writer, ModelNode bindingModel) throws XMLStreamException {
        for (Property binding : bindingModel.asPropertyList()) {
            String type = binding.getValue().get("binding-type").asString();
            if (type.equals("simple")) {
                this.writeSimpleBinding(binding, writer);
                continue;
            }
            if (type.equals("object-factory")) {
                this.writeObjectFactoryBinding(binding, writer);
                continue;
            }
            if (type.equals("lookup")) {
                this.writeLookupBinding(binding, writer);
                continue;
            }
            throw new XMLStreamException("Unknown binding type " + type);
        }
    }

    private void writeSimpleBinding(Property binding, XMLExtendedStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(NamingSubsystemXMLElement.SIMPLE.getLocalName());
        writer.writeAttribute(NamingSubsystemXMLAttribute.NAME.getLocalName(), binding.getName());
        NamingBindingResourceDefinition.VALUE.marshallAsAttribute(binding.getValue(), (XMLStreamWriter)writer);
        NamingBindingResourceDefinition.TYPE.marshallAsAttribute(binding.getValue(), (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    private void writeObjectFactoryBinding(Property binding, XMLExtendedStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(NamingSubsystemXMLElement.OBJECT_FACTORY.getLocalName());
        writer.writeAttribute(NamingSubsystemXMLAttribute.NAME.getLocalName(), binding.getName());
        NamingBindingResourceDefinition.MODULE.marshallAsAttribute(binding.getValue(), (XMLStreamWriter)writer);
        NamingBindingResourceDefinition.CLASS.marshallAsAttribute(binding.getValue(), (XMLStreamWriter)writer);
        NamingBindingResourceDefinition.OBJECT_FACTORY_ENV.marshallAsElement(binding.getValue(), (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    private void writeLookupBinding(Property binding, XMLExtendedStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(NamingSubsystemXMLElement.LOOKUP.getLocalName());
        writer.writeAttribute(NamingSubsystemXMLAttribute.NAME.getLocalName(), binding.getName());
        NamingBindingResourceDefinition.LOOKUP.marshallAsAttribute(binding.getValue(), (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{NamingExtension.SUBSYSTEM_PATH});
        ModelNode ejb3SubsystemAddOperation = Util.createAddOperation((PathAddress)address);
        operations.add(ejb3SubsystemAddOperation);
        EnumSet<NamingSubsystemXMLElement> encountered = EnumSet.noneOf(NamingSubsystemXMLElement.class);
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (NamingSubsystemNamespace.forUri(reader.getNamespaceURI())) {
                case NAMING_1_3: {
                    NamingSubsystemXMLElement element = NamingSubsystemXMLElement.forName(reader.getLocalName());
                    if (!encountered.add(element)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    switch (element) {
                        case BINDINGS: {
                            this.parseBindings(reader, operations, address);
                            continue block7;
                        }
                        case REMOTE_NAMING: {
                            this.parseRemoteNaming(reader, operations, address);
                            continue block7;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseRemoteNaming(XMLExtendedStreamReader reader, List<ModelNode> operations, PathAddress parent) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(Util.createAddOperation((PathAddress)parent.append("service", "remote-naming")));
    }

    private void parseBindings(XMLExtendedStreamReader reader, List<ModelNode> operations, PathAddress address) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (NamingSubsystemXMLElement.forName(reader.getLocalName())) {
                case SIMPLE: {
                    this.parseSimpleBinding(reader, operations, address);
                    continue block5;
                }
                case OBJECT_FACTORY: {
                    this.parseObjectFactoryBinding(reader, operations, address);
                    continue block5;
                }
                case LOOKUP: {
                    this.parseLookupBinding(reader, operations, address);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseSimpleBinding(XMLExtendedStreamReader reader, List<ModelNode> operations, PathAddress parentAddress) throws XMLStreamException {
        String name = null;
        ModelNode bindingAdd = Util.createAddOperation();
        bindingAdd.get("binding-type").set("simple");
        EnumSet<NamingSubsystemXMLAttribute> required = EnumSet.of(NamingSubsystemXMLAttribute.NAME, NamingSubsystemXMLAttribute.VALUE);
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            NamingSubsystemXMLAttribute attribute = NamingSubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value.trim();
                    continue block5;
                }
                case VALUE: {
                    NamingBindingResourceDefinition.VALUE.parseAndSetParameter(value, bindingAdd, (XMLStreamReader)reader);
                    continue block5;
                }
                case TYPE: {
                    NamingBindingResourceDefinition.TYPE.parseAndSetParameter(value, bindingAdd, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        PathAddress address = parentAddress.append("binding", name);
        bindingAdd.get("address").set(address.toModelNode());
        operations.add(bindingAdd);
    }

    private void parseObjectFactoryBinding(XMLExtendedStreamReader reader, List<ModelNode> operations, PathAddress parentAddress) throws XMLStreamException {
        int attCount = reader.getAttributeCount();
        String name = null;
        ModelNode bindingAdd = Util.createAddOperation();
        bindingAdd.get("binding-type").set("object-factory");
        EnumSet<NamingSubsystemXMLAttribute> required = EnumSet.of(NamingSubsystemXMLAttribute.NAME, NamingSubsystemXMLAttribute.MODULE, NamingSubsystemXMLAttribute.CLASS);
        block8: for (int i = 0; i < attCount; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            NamingSubsystemXMLAttribute attribute = NamingSubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value.trim();
                    continue block8;
                }
                case MODULE: {
                    NamingBindingResourceDefinition.MODULE.parseAndSetParameter(value, bindingAdd, (XMLStreamReader)reader);
                    continue block8;
                }
                case CLASS: {
                    NamingBindingResourceDefinition.CLASS.parseAndSetParameter(value, bindingAdd, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        bindingAdd.get("address").set(parentAddress.append("binding", name).toModelNode());
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (NamingSubsystemXMLElement.forName(reader.getLocalName())) {
                case OBJECT_FACTORY_ENV: {
                    this.parseObjectFactoryBindingEnvironment(reader, bindingAdd);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(bindingAdd);
    }

    private void parseObjectFactoryBindingEnvironment(XMLExtendedStreamReader reader, ModelNode bindingAdd) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (NamingSubsystemXMLElement.forName(reader.getLocalName())) {
                case OBJECT_FACTORY_ENV_PROPERTY: {
                    String[] array = ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])new String[]{Attribute.NAME.getLocalName(), Attribute.VALUE.getLocalName()});
                    NamingBindingResourceDefinition.OBJECT_FACTORY_ENV.parseAndAddParameterElement(array[0], array[1], bindingAdd, reader);
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseLookupBinding(XMLExtendedStreamReader reader, List<ModelNode> operations, PathAddress parentAddress) throws XMLStreamException {
        int attCount = reader.getAttributeCount();
        String name = null;
        ModelNode bindingAdd = Util.createAddOperation();
        bindingAdd.get("binding-type").set("lookup");
        EnumSet<NamingSubsystemXMLAttribute> required = EnumSet.of(NamingSubsystemXMLAttribute.NAME, NamingSubsystemXMLAttribute.LOOKUP);
        block4: for (int i = 0; i < attCount; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            NamingSubsystemXMLAttribute attribute = NamingSubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value.trim();
                    continue block4;
                }
                case LOOKUP: {
                    NamingBindingResourceDefinition.LOOKUP.parseAndSetParameter(value, bindingAdd, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        bindingAdd.get("address").set(parentAddress.append("binding", name).toModelNode());
        operations.add(bindingAdd);
    }
}

