/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.util.concurrent.Future;
import org.jboss.as.controller.client.helpers.standalone.DeploymentAction;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlan;
import org.jboss.as.controller.client.helpers.standalone.InitialDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentActionResult;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentPlanResult;
import org.jboss.as.osgi.plugin.OSGiPluginLogger;
import org.jboss.osgi.testing.OSGiDeployerClient;

public class DeployerClientImpl
implements OSGiDeployerClient {
    private ServerDeploymentManager deploymentManager;

    public DeployerClientImpl() throws IOException {
        InetAddress address = InetAddress.getByName("127.0.0.1");
        this.deploymentManager = ServerDeploymentManager.Factory.create((InetAddress)address, (int)9999);
    }

    public String deploy(URL url) throws Exception {
        InitialDeploymentPlanBuilder builder = this.deploymentManager.newDeploymentPlan();
        builder = builder.add(url).andDeploy();
        DeploymentPlan plan = builder.build();
        DeploymentAction deployAction = builder.getLastAction();
        return this.executeDeploymentPlan(plan, deployAction);
    }

    public String deploy(String name, InputStream input) throws Exception {
        InitialDeploymentPlanBuilder builder = this.deploymentManager.newDeploymentPlan();
        builder = builder.add(name, input).andDeploy();
        DeploymentPlan plan = builder.build();
        DeploymentAction deployAction = builder.getLastAction();
        return this.executeDeploymentPlan(plan, deployAction);
    }

    public void undeploy(String uniqueName) {
        try {
            InitialDeploymentPlanBuilder builder = this.deploymentManager.newDeploymentPlan();
            DeploymentPlan plan = builder.undeploy(uniqueName).remove(uniqueName).build();
            Future future = this.deploymentManager.execute(plan);
            future.get();
        }
        catch (Throwable ex) {
            OSGiPluginLogger.ROOT_LOGGER.cannotUndeploy(ex, uniqueName);
        }
    }

    private String executeDeploymentPlan(DeploymentPlan plan, DeploymentAction deployAction) throws Exception {
        Exception deploymentException;
        Future future = this.deploymentManager.execute(plan);
        ServerDeploymentPlanResult planResult = (ServerDeploymentPlanResult)future.get();
        ServerDeploymentActionResult actionResult = planResult.getDeploymentActionResult(deployAction.getId());
        if (actionResult != null && (deploymentException = (Exception)actionResult.getDeploymentException()) != null) {
            throw deploymentException;
        }
        return deployAction.getDeploymentUnitUniqueName();
    }
}

