/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.as.process;

/**
 *
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 */
public class CommandLineConstants {

    /** The ProcessController address */
    public static final String INTERPROCESS_PC_ADDRESS = "-pc-address";

    /** The ProcessController port */
    public static final String INTERPROCESS_PC_PORT = "-pc-port";

    /** The name of a process started by the process controller */
    public static final String INTERPROCESS_NAME = "-interprocess-name";

    /** The HostController address */
    public static final String INTERPROCESS_HC_ADDRESS = "-interprocess-hc-address";

    /** The HostController port */
    public static final String INTERPROCESS_HC_PORT = "-interprocess-hc-port";

    /** Get the version of the server */
    public static final String VERSION = "-version";

    /** Configure the file to be used to read properties */
    public static final String PROPERTIES = "-properties";

    /** Configure a default jvm */
    public static final String DEFAULT_JVM = "-default-jvm";

    /** Passed in when the host controller is respawned by process controller */
    public static final String RESTART_HOST_CONTROLLER = "-restarted-host-controller";

    /** Passed in to a slave host controller to get a backup of all files on the domain controller" */
    public static final String BACKUP_DC = "-backup";

    /** Passed in to a slave host controller to attempt to start up using its cached copy of the remote DC, if the remote DC can not be contacted" */
    public static final String CACHED_DC = "-cached-dc";

    /** Output usage */
    public static final String HELP = "-help";

    private CommandLineConstants() {
    }
}
