/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.process;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.process.ProcessInfo;
import org.jboss.as.process.ProcessLogger;
import org.jboss.as.process.ProcessMessageHandler;
import org.jboss.as.process.ProcessMessages;
import org.jboss.as.process.protocol.Connection;
import org.jboss.as.process.protocol.MessageHandler;
import org.jboss.as.process.protocol.ProtocolClient;
import org.jboss.as.process.protocol.StreamUtils;

public final class ProcessControllerClient
implements Closeable {
    private final Connection connection;

    ProcessControllerClient(Connection connection) {
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessControllerClient connect(ProtocolClient.Configuration configuration, final byte[] authCode, final ProcessMessageHandler messageHandler) throws IOException {
        if (configuration == null) {
            throw ProcessMessages.MESSAGES.nullVar("configuration");
        }
        if (authCode == null) {
            throw ProcessMessages.MESSAGES.nullVar("authCode");
        }
        if (messageHandler == null) {
            throw ProcessMessages.MESSAGES.nullVar("messageHandler");
        }
        configuration.setMessageHandler(new MessageHandler(){

            @Override
            public void handleMessage(Connection connection, InputStream dataStream) throws IOException {
                ProcessControllerClient client = (ProcessControllerClient)connection.getAttachment();
                int cmd = StreamUtils.readUnsignedByte(dataStream);
                switch (cmd) {
                    case 16: {
                        String processName = StreamUtils.readUTFZBytes(dataStream);
                        dataStream.close();
                        ProcessLogger.CLIENT_LOGGER.tracef("Received process_added for process %s", processName);
                        messageHandler.handleProcessAdded(client, processName);
                        break;
                    }
                    case 17: {
                        String processName = StreamUtils.readUTFZBytes(dataStream);
                        dataStream.close();
                        ProcessLogger.CLIENT_LOGGER.tracef("Received process_started for process %s", processName);
                        messageHandler.handleProcessStarted(client, processName);
                        break;
                    }
                    case 18: {
                        String processName = StreamUtils.readUTFZBytes(dataStream);
                        long uptimeMillis = StreamUtils.readLong(dataStream);
                        dataStream.close();
                        ProcessLogger.CLIENT_LOGGER.tracef("Received process_stopped for process %s", processName);
                        messageHandler.handleProcessStopped(client, processName, uptimeMillis);
                        break;
                    }
                    case 19: {
                        String processName = StreamUtils.readUTFZBytes(dataStream);
                        dataStream.close();
                        ProcessLogger.CLIENT_LOGGER.tracef("Received process_removed for process %s", processName);
                        messageHandler.handleProcessRemoved(client, processName);
                        break;
                    }
                    case 20: {
                        int cnt = StreamUtils.readInt(dataStream);
                        HashMap<String, ProcessInfo> inventory = new HashMap<String, ProcessInfo>();
                        for (int i = 0; i < cnt; ++i) {
                            String processName = StreamUtils.readUTFZBytes(dataStream);
                            byte[] processAuthCode = new byte[16];
                            boolean processRunning = StreamUtils.readBoolean(dataStream);
                            StreamUtils.readFully(dataStream, processAuthCode);
                            inventory.put(processName, new ProcessInfo(processName, authCode, processRunning));
                        }
                        dataStream.close();
                        ProcessLogger.CLIENT_LOGGER.tracef("Received process_inventory", new Object[0]);
                        messageHandler.handleProcessInventory(client, inventory);
                        break;
                    }
                    default: {
                        ProcessLogger.CLIENT_LOGGER.receivedUnknownMessageCode(cmd);
                        dataStream.close();
                    }
                }
            }

            @Override
            public void handleShutdown(Connection connection) throws IOException {
                ProcessControllerClient client = (ProcessControllerClient)connection.getAttachment();
                messageHandler.handleConnectionShutdown(client);
            }

            @Override
            public void handleFailure(Connection connection, IOException cause) throws IOException {
                ProcessControllerClient client = (ProcessControllerClient)connection.getAttachment();
                messageHandler.handleConnectionFailure(client, cause);
            }

            @Override
            public void handleFinished(Connection connection) throws IOException {
                ProcessControllerClient client = (ProcessControllerClient)connection.getAttachment();
                messageHandler.handleConnectionFinished(client);
            }
        });
        ProtocolClient client = new ProtocolClient(configuration);
        Connection connection = client.connect();
        boolean ok = false;
        try {
            ProcessControllerClient processControllerClient;
            OutputStream os = connection.writeMessage();
            try {
                os.write(238);
                os.write(1);
                os.write(authCode);
                ProcessControllerClient processControllerClient2 = new ProcessControllerClient(connection);
                connection.attach(processControllerClient2);
                ProcessLogger.CLIENT_LOGGER.trace("Sent initial greeting message");
                os.close();
                ok = true;
                processControllerClient = processControllerClient2;
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(os);
                throw throwable;
            }
            StreamUtils.safeClose(os);
            return processControllerClient;
        }
        finally {
            if (!ok) {
                StreamUtils.safeClose(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream sendStdin(String processName) throws IOException {
        OutputStream os = this.connection.writeMessage();
        boolean ok = false;
        try {
            os.write(20);
            StreamUtils.writeUTFZBytes(os, processName);
            ok = true;
            OutputStream outputStream = os;
            return outputStream;
        }
        finally {
            if (!ok) {
                StreamUtils.safeClose(os);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProcess(String processName, byte[] authKey, String[] cmd, String workingDir, Map<String, String> env) throws IOException {
        if (processName == null) {
            throw ProcessMessages.MESSAGES.nullVar("processName");
        }
        if (authKey == null) {
            throw ProcessMessages.MESSAGES.nullVar("authKey");
        }
        if (cmd == null) {
            throw ProcessMessages.MESSAGES.nullVar("cmd");
        }
        if (workingDir == null) {
            throw ProcessMessages.MESSAGES.nullVar("workingDir");
        }
        if (env == null) {
            throw ProcessMessages.MESSAGES.nullVar("env");
        }
        if (cmd.length < 1) {
            throw ProcessMessages.MESSAGES.invalidCommandLen();
        }
        if (authKey.length != 16) {
            throw ProcessMessages.MESSAGES.invalidAuthKeyLen();
        }
        OutputStream os = this.connection.writeMessage();
        try {
            os.write(16);
            StreamUtils.writeUTFZBytes(os, processName);
            os.write(authKey);
            StreamUtils.writeInt(os, cmd.length);
            for (String c : cmd) {
                StreamUtils.writeUTFZBytes(os, c);
            }
            StreamUtils.writeInt(os, env.size());
            for (String key : env.keySet()) {
                String value = env.get(key);
                StreamUtils.writeUTFZBytes(os, key);
                if (value != null) {
                    StreamUtils.writeUTFZBytes(os, value);
                    continue;
                }
                StreamUtils.writeUTFZBytes(os, "");
            }
            StreamUtils.writeUTFZBytes(os, workingDir);
            os.close();
        }
        finally {
            StreamUtils.safeClose(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startProcess(String processName) throws IOException {
        if (processName == null) {
            throw ProcessMessages.MESSAGES.nullVar("processName");
        }
        OutputStream os = this.connection.writeMessage();
        try {
            os.write(17);
            StreamUtils.writeUTFZBytes(os, processName);
            os.close();
        }
        finally {
            StreamUtils.safeClose(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopProcess(String processName) throws IOException {
        if (processName == null) {
            throw ProcessMessages.MESSAGES.nullVar("processName");
        }
        OutputStream os = this.connection.writeMessage();
        try {
            os.write(18);
            StreamUtils.writeUTFZBytes(os, processName);
            os.close();
        }
        finally {
            StreamUtils.safeClose(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProcess(String processName) throws IOException {
        if (processName == null) {
            throw ProcessMessages.MESSAGES.nullVar("processName");
        }
        OutputStream os = this.connection.writeMessage();
        try {
            os.write(19);
            StreamUtils.writeUTFZBytes(os, processName);
            os.close();
        }
        finally {
            StreamUtils.safeClose(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestProcessInventory() throws IOException {
        OutputStream os = this.connection.writeMessage();
        try {
            os.write(21);
            os.close();
        }
        finally {
            StreamUtils.safeClose(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnectProcess(String processName, String hostName, int port, boolean managementSubsystemEndpoint, byte[] authKey) throws IOException {
        if (processName == null) {
            throw ProcessMessages.MESSAGES.nullVar("processName");
        }
        OutputStream os = this.connection.writeMessage();
        try {
            os.write(22);
            StreamUtils.writeUTFZBytes(os, processName);
            StreamUtils.writeUTFZBytes(os, hostName);
            StreamUtils.writeInt(os, port);
            StreamUtils.writeBoolean(os, managementSubsystemEndpoint);
            os.write(authKey);
            os.close();
        }
        finally {
            StreamUtils.safeClose(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws IOException {
        OutputStream os = this.connection.writeMessage();
        try {
            os.write(23);
            os.close();
        }
        finally {
            StreamUtils.safeClose(os);
        }
    }

    @Override
    public void close() throws IOException {
        this.connection.close();
    }
}

