/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol.mgmt;

import java.io.IOException;
import java.io.InputStream;
import org.jboss.as.protocol.Connection;
import org.jboss.as.protocol.MessageHandler;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.logging.Logger;

public abstract class AbstractMessageHandler
implements MessageHandler {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.management");

    @Override
    public void handleShutdown(Connection connection) throws IOException {
        connection.shutdownWrites();
    }

    @Override
    public void handleFailure(Connection connection, IOException e) throws IOException {
        log.error((Object)e);
        connection.shutdownWrites();
    }

    @Override
    public void handleFinished(Connection connection) throws IOException {
    }

    @Override
    public void handleMessage(Connection connection, InputStream inputStream) throws IOException {
        try {
            this.handle(connection, inputStream);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Failed to handle management operation", e);
        }
        finally {
            StreamUtils.safeClose(inputStream);
        }
    }

    public abstract void handle(Connection var1, InputStream var2) throws IOException;
}

