/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol.mgmt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.jboss.as.protocol.ProtocolUtils;
import org.jboss.as.protocol.mgmt.ManagementProtocol;

public abstract class ManagementProtocolHeader {
    protected int version;

    protected ManagementProtocolHeader() {
    }

    protected ManagementProtocolHeader(DataInput input) throws IOException {
        this.read(input);
    }

    protected ManagementProtocolHeader(int version) {
        this.version = version;
    }

    public void read(DataInput input) throws IOException {
        this.validateSignature(input);
        ProtocolUtils.expectHeader(input, 0);
        this.version = input.readInt();
    }

    public void write(DataOutput output) throws IOException {
        output.write(ManagementProtocol.SIGNATURE);
        output.writeByte(0);
        output.writeInt(this.getVersion());
    }

    public int getVersion() {
        return this.version;
    }

    protected void validateSignature(DataInput input) throws IOException {
        byte[] signatureBytes = new byte[4];
        input.readFully(signatureBytes);
        if (!Arrays.equals(ManagementProtocol.SIGNATURE, signatureBytes)) {
            throw new IOException("Invalid signature [" + Arrays.toString(signatureBytes) + "]");
        }
    }
}

