/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol;

import java.io.IOException;
import java.io.OutputStream;
import org.jboss.marshalling.ByteOutput;

public class ChunkyByteOutput
extends OutputStream
implements ByteOutput {
    public static final int CHUNK_START = 152;
    public static final int END = 153;
    private final ByteOutput output;
    private final byte[] buffer;
    private int position;

    public ChunkyByteOutput(ByteOutput output) {
        this(output, 8192);
    }

    public ChunkyByteOutput(ByteOutput output, int bufferSize) {
        this.output = output;
        this.buffer = new byte[bufferSize];
    }

    @Override
    public void write(int v) throws IOException {
        int position = this.position;
        byte[] buffer = this.buffer;
        if (position == buffer.length) {
            this.flush();
            buffer[0] = (byte)v;
            this.position = 1;
        } else {
            buffer[position] = (byte)v;
            this.position = position + 1;
        }
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        byte[] buffer = this.buffer;
        int position = this.position;
        int offSet = off;
        while (offSet < len) {
            int toRead = len - offSet;
            int remaining = buffer.length - position;
            if (toRead < remaining) {
                System.arraycopy(bytes, offSet, buffer, position, toRead);
                this.position = position + toRead;
                offSet += len;
                continue;
            }
            System.arraycopy(bytes, offSet, buffer, position, remaining);
            this.position += remaining;
            this.flush();
            offSet += remaining;
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.output.write(153);
    }

    @Override
    public void flush() throws IOException {
        ByteOutput output = this.output;
        int pos = this.position;
        if (pos > 0) {
            output.write(152);
            this.writeInt(pos);
            byte[] buffer = this.buffer;
            output.write(buffer, 0, pos);
        }
        this.position = 0;
    }

    public void writeInt(int i) throws IOException {
        ByteOutput output = this.output;
        byte[] bytes = new byte[]{(byte)(i >> 24), (byte)(i >> 16), (byte)(i >> 8), (byte)i};
        output.write(bytes);
    }
}

