/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol.mgmt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jboss.as.protocol.mgmt.ManagementProtocolHeader;
import org.jboss.as.protocol.old.ProtocolUtils;

class ManagementResponseHeader
extends ManagementProtocolHeader {
    private int responseId;
    private String error;

    public ManagementResponseHeader(int version, int responseId, String error) {
        super(version);
        this.responseId = responseId;
        this.error = error;
    }

    ManagementResponseHeader(int version, DataInput input) throws IOException {
        super(version);
        this.read(input);
    }

    public void read(DataInput input) throws IOException {
        ProtocolUtils.expectHeader(input, 32);
        this.responseId = input.readInt();
        ProtocolUtils.expectHeader(input, 33);
        byte type = input.readByte();
        if (type == 35) {
            this.error = input.readUTF();
        } else if (type != 34) {
            throw new IllegalArgumentException("Type is neither RESPONSE_ERROR not RESPONSE_BODY: " + type);
        }
    }

    @Override
    public void write(DataOutput output) throws IOException {
        super.write(output);
        output.write(32);
        output.writeInt(this.responseId);
        output.write(33);
        if (this.error != null) {
            output.write(35);
            output.writeUTF(this.error);
        } else {
            output.write(34);
        }
    }

    public int getResponseId() {
        return this.responseId;
    }

    public String getError() {
        return this.error;
    }

    @Override
    byte getType() {
        return 3;
    }
}

