/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.concurrent.Executor;
import org.jboss.as.model.AbstractSubsystemAdd;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.as.remoting.EndpointService;
import org.jboss.as.remoting.Namespace;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.remoting.RemotingSubsystemElement;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.msc.inject.CastingInjector;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.xnio.OptionMap;

public final class RemotingSubsystemAdd
extends AbstractSubsystemAdd<RemotingSubsystemElement> {
    private static final long serialVersionUID = -3368184946165491737L;
    private final String threadPoolName;

    protected RemotingSubsystemAdd(String threadPoolName) {
        super(Namespace.CURRENT.getUriString());
        this.threadPoolName = threadPoolName;
    }

    protected <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        EndpointService endpointService = new EndpointService();
        endpointService.setOptionMap(OptionMap.EMPTY);
        BatchServiceBuilder endpointBuilder = updateContext.getBatchBuilder().addService(RemotingServices.ENDPOINT, (Service)endpointService);
        Injector<Executor> executorInjector = endpointService.getExecutorInjector();
        endpointBuilder.addDependency(ThreadsServices.executorName((String)this.threadPoolName), (Injector)new CastingInjector(executorInjector, Executor.class));
        endpointBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
    }

    protected RemotingSubsystemElement createSubsystemElement() {
        RemotingSubsystemElement element = new RemotingSubsystemElement();
        element.setThreadPoolName(this.threadPoolName);
        return element;
    }
}

