/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.xnio.IoFuture;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;

public abstract class AbstractOutboundConnectionService<T extends AbstractOutboundConnectionService>
implements Service<T> {
    public static final ServiceName OUTBOUND_CONNECTION_BASE_SERVICE_NAME = RemotingServices.SUBSYSTEM_ENDPOINT.append(new String[]{"outbound-connection"});
    protected final InjectedValue<Endpoint> endpointInjectedValue = new InjectedValue();
    protected volatile OptionMap connectionCreationOptions;
    protected final String connectionName;

    protected AbstractOutboundConnectionService(String connectionName, OptionMap connectionCreationOptions) {
        this.connectionName = connectionName;
        this.connectionCreationOptions = connectionCreationOptions == null ? OptionMap.EMPTY : connectionCreationOptions;
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    Injector<Endpoint> getEnpointInjector() {
        return this.endpointInjectedValue;
    }

    void setConnectionCreationOptions(OptionMap connectionCreationOptions) {
        this.connectionCreationOptions = connectionCreationOptions == null ? this.getDefaultOptionMap() : connectionCreationOptions;
    }

    private OptionMap getDefaultOptionMap() {
        return OptionMap.create((Option)Options.SSL_ENABLED, (Object)true, (Option)Options.SSL_STARTTLS, (Object)true);
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public abstract IoFuture<Connection> connect() throws IOException;

    protected CallbackHandler getCallbackHandler() {
        return new AnonymousCallbackHandler();
    }

    private class AnonymousCallbackHandler
    implements CallbackHandler {
        private AnonymousCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback current : callbacks) {
                if (!(current instanceof NameCallback)) {
                    throw new UnsupportedCallbackException(current);
                }
                NameCallback ncb = (NameCallback)current;
                ncb.setName("anonymous");
            }
        }
    }
}

