/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import org.jboss.as.server.deployment.AbstractDeploymentUnitService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitImpl;
import org.jboss.as.server.deployment.api.ServerDeploymentRepository;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.value.InjectedValue;

public final class RootDeploymentUnitService
extends AbstractDeploymentUnitService {
    private final InjectedValue<ServerDeploymentRepository> serverDeploymentRepositoryInjector = new InjectedValue();
    private final String name;
    private final String runtimeName;
    private final byte[] deploymentHash;
    private final DeploymentUnit parent;

    public RootDeploymentUnitService(String name, String runtimeName, byte[] deploymentHash, DeploymentUnit parent, AbstractDeploymentUnitService.DeploymentCompletionCallback callback) {
        super(callback);
        this.name = name;
        this.parent = parent;
        this.runtimeName = runtimeName;
        this.deploymentHash = deploymentHash;
    }

    @Override
    protected DeploymentUnit createAndInitializeDeploymentUnit(ServiceRegistry registry) {
        DeploymentUnitImpl deploymentUnit = new DeploymentUnitImpl(this.parent, this.name, registry);
        deploymentUnit.putAttachment(Attachments.RUNTIME_NAME, this.runtimeName);
        deploymentUnit.putAttachment(Attachments.DEPLOYMENT_HASH, this.deploymentHash);
        deploymentUnit.putAttachment(Attachments.SERVER_DEPLOYMENT_REPOSITORY, this.serverDeploymentRepositoryInjector.getValue());
        return deploymentUnit;
    }

    Injector<ServerDeploymentRepository> getServerDeploymentRepositoryInjector() {
        return this.serverDeploymentRepositoryInjector;
    }
}

