/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.net;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import org.jboss.as.server.services.net.ManagedDatagramSocketBinding;
import org.jboss.as.server.services.net.ManagedMulticastSocketBinding;
import org.jboss.as.server.services.net.NetworkInterfaceBinding;
import org.jboss.as.server.services.net.SocketBindingManager;
import org.jboss.msc.service.ServiceName;

public class SocketBinding {
    public static final ServiceName JBOSS_BINDING_NAME = ServiceName.JBOSS.append(new String[]{"binding"});
    private final String name;
    private int port;
    private boolean isFixedPort;
    private InetAddress multicastAddress;
    private int multicastPort;
    private final NetworkInterfaceBinding networkInterface;
    private final SocketBindingManager socketBindings;

    SocketBinding(String name, int port, boolean isFixedPort, InetAddress multicastAddress, int multicastPort, NetworkInterfaceBinding networkInterface, SocketBindingManager socketBindings) {
        this.name = name;
        this.port = port;
        this.isFixedPort = isFixedPort;
        this.multicastAddress = multicastAddress;
        this.multicastPort = multicastPort;
        this.socketBindings = socketBindings;
        this.networkInterface = networkInterface;
    }

    public String getName() {
        return this.name;
    }

    public InetAddress getAddress() {
        return this.networkInterface != null ? this.networkInterface.getAddress() : this.socketBindings.getDefaultInterfaceAddress();
    }

    public SocketBindingManager getSocketBindings() {
        return this.socketBindings;
    }

    public InetSocketAddress getSocketAddress() {
        int port = this.port;
        if (port > 0 && !this.isFixedPort) {
            port += this.socketBindings.getPortOffset();
        }
        return new InetSocketAddress(this.getAddress(), port);
    }

    public InetSocketAddress getMulticastSocketAddress() {
        if (this.multicastAddress == null) {
            throw new IllegalStateException("no multicast binding: " + this.name);
        }
        return new InetSocketAddress(this.multicastAddress, this.multicastPort);
    }

    public Socket createSocket() throws IOException {
        Socket socket = this.getSocketFactory().createSocket();
        socket.bind(this.getSocketAddress());
        return socket;
    }

    public ServerSocket createServerSocket() throws IOException {
        ServerSocket socket = this.getServerSocketFactory().createServerSocket();
        socket.bind(this.getSocketAddress());
        return socket;
    }

    public ServerSocket createServerSocket(int backlog) throws IOException {
        ServerSocket socket = this.getServerSocketFactory().createServerSocket();
        socket.bind(this.getSocketAddress(), backlog);
        return socket;
    }

    public DatagramSocket createDatagramSocket() throws SocketException {
        return new ManagedDatagramSocketBinding(this.socketBindings, this.getSocketAddress());
    }

    public MulticastSocket createMulticastSocket() throws IOException {
        return new ManagedMulticastSocketBinding(this.socketBindings, this.getSocketAddress());
    }

    SocketFactory getSocketFactory() {
        return this.socketBindings.getSocketFactory();
    }

    ServerSocketFactory getServerSocketFactory() {
        return this.socketBindings.getServerSocketFactory();
    }
}

