/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.jboss.as.embedded.ServerStartException;
import org.jboss.as.embedded.StandaloneServer;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.server.Bootstrap;
import org.jboss.as.server.Main;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.threads.AsyncFuture;

public class EmbeddedStandAloneServerFactory {
    public static final String JBOSS_EMBEDDED_ROOT = "jboss.embedded.root";

    private EmbeddedStandAloneServerFactory() {
    }

    public static StandaloneServer create(File jbossHomeDir, final ModuleLoader moduleLoader, final Properties systemProps, final Map<String, String> systemEnv) {
        EmbeddedStandAloneServerFactory.setupCleanDirectories(jbossHomeDir, systemProps);
        StandaloneServer standaloneServer = new StandaloneServer(){
            private ServiceContainer serviceContainer;

            public void start() throws ServerStartException {
                try {
                    ServerEnvironment serverEnviromment = Main.determineEnvironment(new String[0], systemProps, systemEnv);
                    Bootstrap bootstrap = Bootstrap.Factory.newInstance();
                    Bootstrap.Configuration configuration = new Bootstrap.Configuration();
                    configuration.setServerEnvironment(serverEnviromment);
                    configuration.setModuleLoader(moduleLoader);
                    AsyncFuture<ServiceContainer> future = bootstrap.startup(configuration, Collections.<ServiceActivator>emptyList());
                    this.serviceContainer = (ServiceContainer)future.get();
                }
                catch (RuntimeException rte) {
                    throw rte;
                }
                catch (Exception ex) {
                    throw new ServerStartException((Throwable)ex);
                }
            }

            public void stop() {
                if (this.serviceContainer != null) {
                    try {
                        this.serviceContainer.shutdown();
                        this.serviceContainer.awaitTermination();
                    }
                    catch (RuntimeException rte) {
                        throw rte;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        };
        return standaloneServer;
    }

    public static void setupCleanDirectories(Properties props) {
        File jbossHomeDir = new File(props.getProperty("jboss.home.dir"));
        EmbeddedStandAloneServerFactory.setupCleanDirectories(jbossHomeDir, props);
    }

    static void setupCleanDirectories(File jbossHomeDir, Properties props) {
        File tempRoot = EmbeddedStandAloneServerFactory.getTempRoot(props);
        if (tempRoot == null) {
            return;
        }
        File originalConfigDir = EmbeddedStandAloneServerFactory.getFileUnderAsRoot(jbossHomeDir, props, "jboss.server.config.dir", "configuration", true);
        File originalDataDir = EmbeddedStandAloneServerFactory.getFileUnderAsRoot(jbossHomeDir, props, "jboss.server.data.dir", "data", false);
        File configDir = new File(tempRoot, "config");
        configDir.mkdir();
        File dataDir = new File(tempRoot, "data");
        dataDir.mkdir();
        File deploymentsDir = new File(tempRoot, "deployments");
        deploymentsDir.mkdir();
        EmbeddedStandAloneServerFactory.copyDirectory(originalConfigDir, configDir);
        if (originalDataDir.exists()) {
            EmbeddedStandAloneServerFactory.copyDirectory(originalDataDir, dataDir);
        }
        props.put("jboss.server.base.dir", tempRoot.getAbsolutePath());
        props.put("jboss.server.config.dir", configDir.getAbsolutePath());
        props.put("jboss.server.data.dir", dataDir.getAbsolutePath());
    }

    private static File getFileUnderAsRoot(File jbossHomeDir, Properties props, String propName, String relativeLocation, boolean mustExist) {
        String prop = props.getProperty(propName, null);
        if (prop == null) {
            prop = props.getProperty("jboss.server.base.dir", null);
            if (prop == null) {
                File dir = new File(jbossHomeDir, "standalone/" + relativeLocation);
                if (!(!mustExist || dir.exists() && dir.isDirectory())) {
                    throw new IllegalArgumentException("No directory called 'standalone/' " + relativeLocation + " under " + jbossHomeDir.getAbsolutePath());
                }
                return dir;
            }
            File server = new File(prop);
            EmbeddedStandAloneServerFactory.validateDirectory("jboss.server.base.dir", server);
            return new File(server, relativeLocation);
        }
        File dir = new File(prop);
        EmbeddedStandAloneServerFactory.validateDirectory("jboss.server.config.dir", dir);
        return dir;
    }

    private static File getTempRoot(Properties props) {
        String tempRoot = props.getProperty(JBOSS_EMBEDDED_ROOT, null);
        if (tempRoot == null) {
            return null;
        }
        File root = new File(tempRoot);
        if (!root.exists()) {
            root.mkdirs();
        }
        EmbeddedStandAloneServerFactory.validateDirectory("jboss.test.clean.root", root);
        root = new File(root, "configs");
        root.mkdir();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        root = new File(root, format.format(new Date()));
        root.mkdir();
        return root;
    }

    private static void validateDirectory(String property, File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException("-D" + property + "=" + file.getAbsolutePath() + " does not exist");
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("-D" + property + "=" + file.getAbsolutePath() + " is not a directory");
        }
    }

    private static void copyDirectory(File src, File dest) {
        for (String current : src.list()) {
            File srcFile = new File(src, current);
            File destFile = new File(dest, current);
            if (srcFile.isDirectory()) {
                destFile.mkdir();
                EmbeddedStandAloneServerFactory.copyDirectory(srcFile, destFile);
                continue;
            }
            try {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(srcFile));
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(destFile));
                try {
                    int i;
                    while ((i = ((InputStream)in).read()) != -1) {
                        ((OutputStream)out).write(i);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Error copying " + srcFile.getAbsolutePath() + " to " + destFile.getAbsolutePath(), e);
                }
                finally {
                    StreamUtils.safeClose((Closeable)in);
                    StreamUtils.safeClose((Closeable)out);
                }
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

