/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.server.deployment.ContentServitor;
import org.jboss.as.server.deployment.DeployerChains;
import org.jboss.as.server.deployment.PathContentServitor;
import org.jboss.as.server.deployment.RootDeploymentUnitService;
import org.jboss.as.server.deployment.Services;
import org.jboss.as.server.deployment.api.ServerDeploymentRepository;
import org.jboss.as.server.services.path.AbsolutePathService;
import org.jboss.as.server.services.path.AbstractPathService;
import org.jboss.as.server.services.path.RelativePathService;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.vfs.VirtualFile;

public class DeploymentHandlerUtil {
    private DeploymentHandlerUtil() {
    }

    public static void deploy(OperationContext context, final String deploymentUnitName, final String runtimeName, final ResultHandler resultHandler, final ContentItem ... contents) throws OperationFailedException {
        assert (contents != null) : "contents is null";
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext runtimeContext) throws OperationFailedException {
                    DeploymentHandlerUtil.deploy(runtimeContext, deploymentUnitName, runtimeName, resultHandler, contents);
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
    }

    private static void deploy(RuntimeTaskContext context, String deploymentUnitName, String runtimeName, ResultHandler resultHandler, ContentItem ... contents) {
        ServiceName deploymentUnitServiceName = Services.deploymentUnitName(deploymentUnitName);
        ServiceRegistry serviceRegistry = context.getServiceRegistry();
        ServiceController controller = serviceRegistry.getService(deploymentUnitServiceName);
        if (controller != null) {
            controller.setMode(ServiceController.Mode.ACTIVE);
        } else {
            Object previous;
            ServiceTarget serviceTarget = context.getServiceTarget();
            ServiceName contentsServiceName = deploymentUnitServiceName.append(new String[]{"contents"});
            if (contents[0].hash != null) {
                previous = ContentServitor.addService(serviceTarget, contentsServiceName, contents[0].hash);
            } else {
                String path = contents[0].path;
                ServiceName pathServiceName = AbstractPathService.pathNameOf(path);
                String relativeTo = contents[0].relativeTo;
                previous = relativeTo != null ? RelativePathService.addService(pathServiceName, path, relativeTo, serviceTarget) : AbsolutePathService.addService(pathServiceName, path, serviceTarget);
                final ServiceController<VirtualFile> contentServiceController = PathContentServitor.addService(serviceTarget, contentsServiceName, pathServiceName);
                contentServiceController.addListener((ServiceListener)new AbstractServiceListener<VirtualFile>(){

                    public void serviceRemoved(ServiceController<? extends VirtualFile> serviceController) {
                        contentServiceController.removeListener((ServiceListener)this);
                        previous.setMode(ServiceController.Mode.REMOVE);
                    }
                });
            }
            RootDeploymentUnitService service = new RootDeploymentUnitService(deploymentUnitName, runtimeName, null);
            final ServiceController deploymentUnitController = serviceTarget.addService(deploymentUnitServiceName, (Service)service).addDependency(Services.JBOSS_DEPLOYMENT_CHAINS, DeployerChains.class, service.getDeployerChainsInjector()).addDependency(ServerDeploymentRepository.SERVICE_NAME, ServerDeploymentRepository.class, service.getServerDeploymentRepositoryInjector()).addDependency(contentsServiceName, VirtualFile.class, service.contentsInjector).setInitialMode(ServiceController.Mode.ACTIVE).install();
            previous.addListener((ServiceListener)new AbstractServiceListener<Object>(){

                public void serviceRemoved(ServiceController<? extends Object> controller) {
                    controller.removeListener((ServiceListener)this);
                    deploymentUnitController.setMode(ServiceController.Mode.REMOVE);
                }
            });
        }
        resultHandler.handleResultComplete();
    }

    private static void executeWhenRemoved(final Runnable action, ServiceRegistry serviceRegistry, ServiceName ... serviceNames) {
        final CountDownLatch latch = new CountDownLatch(serviceNames.length);
        final AtomicInteger ticket = new AtomicInteger(serviceNames.length);
        for (ServiceName serviceName : serviceNames) {
            final ServiceController controller = serviceRegistry.getService(serviceName);
            if (controller != null) {
                controller.addListener((ServiceListener)new AbstractServiceListener<Object>(){

                    public void serviceRemoved(ServiceController<? extends Object> serviceController) {
                        controller.removeListener((ServiceListener)this);
                        latch.countDown();
                        if (ticket.decrementAndGet() == 0) {
                            action.run();
                        }
                    }
                });
                continue;
            }
            latch.countDown();
            if (ticket.decrementAndGet() != 0) continue;
            action.run();
        }
    }

    public static void redeploy(OperationContext operationContext, final String deploymentUnitName, final String runtimeName, final ResultHandler resultHandler, final ContentItem ... contents) throws OperationFailedException {
        assert (contents != null) : "contents is null";
        if (operationContext.getRuntimeContext() != null) {
            operationContext.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceController controller = context.getServiceRegistry().getService(Services.deploymentUnitName(deploymentUnitName));
                    if (controller != null) {
                        controller.addListener((ServiceListener)new AbstractServiceListener<Object>(){

                            public void listenerAdded(ServiceController<?> controller) {
                                if (!controller.compareAndSetMode(ServiceController.Mode.ACTIVE, ServiceController.Mode.NEVER)) {
                                    controller.removeListener((ServiceListener)this);
                                }
                            }

                            public void serviceStopping(ServiceController<?> controller) {
                                controller.removeListener((ServiceListener)this);
                                controller.compareAndSetMode(ServiceController.Mode.NEVER, ServiceController.Mode.ACTIVE);
                            }
                        });
                    } else {
                        DeploymentHandlerUtil.deploy(context, deploymentUnitName, runtimeName, resultHandler, contents);
                    }
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
    }

    private static void remove(ServiceRegistry serviceRegistry, ServiceName serviceName) {
        ServiceController controller = serviceRegistry.getService(serviceName);
        controller.setMode(ServiceController.Mode.REMOVE);
    }

    public static void replace(OperationContext operationContext, final String deploymentUnitName, final String runtimeName, final ResultHandler resultHandler, final ContentItem ... contents) throws OperationFailedException {
        assert (contents != null) : "contents is null";
        if (operationContext.getRuntimeContext() != null) {
            operationContext.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(final RuntimeTaskContext runtimeContext) throws OperationFailedException {
                    ServiceName deploymentUnitServiceName = Services.deploymentUnitName(deploymentUnitName);
                    ServiceName contentsServiceName = deploymentUnitServiceName.append(new String[]{"contents"});
                    DeploymentHandlerUtil.executeWhenRemoved(new Runnable(){

                        @Override
                        public void run() {
                            DeploymentHandlerUtil.deploy(runtimeContext, deploymentUnitName, runtimeName, resultHandler, contents);
                        }
                    }, runtimeContext.getServiceRegistry(), new ServiceName[]{deploymentUnitServiceName});
                    DeploymentHandlerUtil.remove(runtimeContext.getServiceRegistry(), contentsServiceName);
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
    }

    public static void undeploy(OperationContext context, final String deploymentUnitName, final ResultHandler resultHandler) {
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceName deploymentUnitServiceName = Services.deploymentUnitName(deploymentUnitName);
                    ServiceRegistry serviceRegistry = context.getServiceRegistry();
                    DeploymentHandlerUtil.remove(serviceRegistry, deploymentUnitServiceName.append(new String[]{"contents"}));
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
    }

    static class ContentItem {
        private byte[] hash;
        private String path;
        private String relativeTo;
        private boolean isArchive;

        ContentItem(byte[] hash) {
            assert (hash != null) : "hash is null";
            this.hash = hash;
        }

        ContentItem(String path, String relativeTo, boolean isArchive) {
            assert (path != null) : "path is null";
            this.path = path;
            this.relativeTo = relativeTo;
            this.isArchive = isArchive;
        }
    }
}

