/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.moduleservice;

import java.util.List;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleSpec;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class ModuleLoadService
implements Service<Module> {
    private final InjectedValue<ServiceModuleLoader> serviceModuleLoader = new InjectedValue();
    private final InjectedValue<ModuleSpec> moduleSpec = new InjectedValue();
    private volatile Module module;

    private ModuleLoadService() {
    }

    public synchronized void start(StartContext context) throws StartException {
        try {
            this.module = ((ServiceModuleLoader)((Object)this.serviceModuleLoader.getValue())).loadModule(((ModuleSpec)this.moduleSpec.getValue()).getModuleIdentifier());
            ((ServiceModuleLoader)((Object)this.serviceModuleLoader.getValue())).relinkModule(this.module);
        }
        catch (ModuleLoadException e) {
            throw new StartException("Failed to load module: " + ((ModuleSpec)this.moduleSpec.getValue()).getModuleIdentifier(), (Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        this.module = null;
    }

    public Module getValue() throws IllegalStateException, IllegalArgumentException {
        return this.module;
    }

    public static ServiceName install(ServiceTarget target, ModuleIdentifier identifier, List<ModuleDependency> dependencies) {
        ModuleLoadService service = new ModuleLoadService();
        ServiceName serviceName = ServiceModuleLoader.moduleServiceName(identifier);
        ServiceBuilder builder = target.addService(serviceName, (Service)service);
        builder.addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ServiceModuleLoader.class, service.getServiceModuleLoader());
        builder.addDependency(ServiceModuleLoader.moduleSpecServiceName(identifier), ModuleSpec.class, service.getModuleSpec());
        for (ModuleDependency dep : dependencies) {
            if (!dep.getIdentifier().getName().startsWith("deployment.")) continue;
            builder.addDependencies(new ServiceName[]{ServiceModuleLoader.moduleSpecServiceName(dep.getIdentifier())});
        }
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
        return serviceName;
    }

    public InjectedValue<ServiceModuleLoader> getServiceModuleLoader() {
        return this.serviceModuleLoader;
    }

    public InjectedValue<ModuleSpec> getModuleSpec() {
        return this.moduleSpec;
    }
}

