/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import java.security.AccessController;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.ManagementDescription;
import org.jboss.as.domain.management.security.SecurityRealmService;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.server.Services;
import org.jboss.as.server.mgmt.HttpManagementService;
import org.jboss.as.server.services.net.NetworkInterfaceService;
import org.jboss.as.server.services.path.AbstractPathService;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.threads.JBossThreadFactory;

public class HttpManagementAddHandler
extends AbstractAddStepHandler
implements DescriptionProvider {
    public static final HttpManagementAddHandler INSTANCE = new HttpManagementAddHandler();
    public static final String OPERATION_NAME = "add";

    protected void populateModel(ModelNode operation, ModelNode model) {
        model.get("interface").set(operation.require("interface").asString());
        if (operation.hasDefined("port")) {
            model.get("port").set(operation.require("port").asInt());
        }
        if (operation.hasDefined("secure-port")) {
            model.get("secure-port").set(operation.require("secure-port").asInt());
        }
        if (operation.hasDefined("security-realm")) {
            model.get("security-realm").set(operation.get("security-realm").asString());
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        String interfaceName = operation.require("interface").asString();
        int port = this.getIntValue(operation, "port");
        int securePort = this.getIntValue(operation, "secure-port");
        String securityRealm = operation.hasDefined("security-realm") ? operation.get("security-realm").asString() : null;
        ServiceTarget serviceTarget = context.getServiceTarget();
        StringBuilder sb = new StringBuilder();
        sb.append("creating http management service using network interface (").append(interfaceName).append(")");
        if (port > -1) {
            sb.append(" port (").append(port).append(")");
        }
        if (securePort > -1) {
            sb.append(" securePort (").append(securePort).append(")");
        }
        Logger.getLogger((String)"org.jboss.as").info((Object)sb.toString());
        HttpManagementService service = new HttpManagementService();
        ServiceBuilder builder = serviceTarget.addService(HttpManagementService.SERVICE_NAME, (Service)service).addDependency(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{interfaceName}), NetworkInterfaceBinding.class, service.getInterfaceInjector()).addDependency(Services.JBOSS_SERVER_CONTROLLER, ModelController.class, service.getModelControllerInjector()).addDependency(AbstractPathService.pathNameOf("jboss.server.temp.dir"), String.class, service.getTempDirInjector()).addInjection(service.getPortInjector(), (Object)port).addInjection(service.getSecurePortInjector(), (Object)securePort).addInjection(service.getExecutorServiceInjector(), (Object)Executors.newCachedThreadPool((ThreadFactory)new JBossThreadFactory(new ThreadGroup("HttpManagementService-threads"), Boolean.FALSE, null, "%G - %t", null, null, AccessController.getContext())));
        if (securityRealm != null) {
            builder.addDependency(SecurityRealmService.BASE_SERVICE_NAME.append(new String[]{securityRealm}), SecurityRealmService.class, service.getSecurityRealmInjector());
        } else {
            Logger.getLogger((String)"org.jboss.as").warn((Object)"No security realm defined for http management service, all access will be unrestricted.");
        }
        newControllers.add(builder.addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install());
    }

    public ModelNode getModelDescription(Locale locale) {
        return ManagementDescription.getAddHttpManagementDescription((Locale)locale);
    }

    private int getIntValue(ModelNode source, String name) {
        if (source.hasDefined(name)) {
            return source.require(name).asInt();
        }
        return -1;
    }
}

