/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.mgmt.domain;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import org.jboss.as.protocol.ProtocolChannelClient;
import org.jboss.as.protocol.ProtocolChannelFactory;
import org.jboss.as.protocol.mgmt.ManagementChannel;
import org.jboss.as.protocol.mgmt.ManagementChannelFactory;
import org.jboss.as.protocol.old.StreamUtils;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Endpoint;
import org.jboss.sasl.JBossSaslProvider;

public class HostControllerConnectionService
implements Service<ManagementChannel> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"host", "controller", "channel"});
    private final InjectedValue<InetSocketAddress> hcAddressInjector = new InjectedValue();
    private final InjectedValue<Endpoint> endpointInjector = new InjectedValue();
    private final Provider saslProvider = new JBossSaslProvider();
    private volatile ManagementChannel channel;
    private volatile ProtocolChannelClient<ManagementChannel> client;
    private final String serverName;
    private final byte[] authKey;

    private HostControllerConnectionService(String serverName, byte[] authKey) {
        this.serverName = serverName;
        this.authKey = authKey;
    }

    public static void install(ServiceTarget serviceTarget, InetSocketAddress managementSocket, String serverName, byte[] authKey) {
        HostControllerConnectionService hcConnection = new HostControllerConnectionService(serverName, authKey);
        serviceTarget.addService(SERVICE_NAME, (Service)hcConnection).addInjection(hcConnection.hcAddressInjector, (Object)managementSocket).addDependency(RemotingServices.ENDPOINT, Endpoint.class, hcConnection.endpointInjector).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    public synchronized void start(StartContext context) throws StartException {
        ProtocolChannelClient client;
        AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                return Security.insertProviderAt(HostControllerConnectionService.this.saslProvider, 1);
            }
        });
        try {
            ProtocolChannelClient.Configuration configuration = new ProtocolChannelClient.Configuration();
            configuration.setEndpoint((Endpoint)this.endpointInjector.getValue());
            configuration.setUri(new URI("remote://" + ((InetSocketAddress)this.hcAddressInjector.getValue()).getHostName() + ":" + ((InetSocketAddress)this.hcAddressInjector.getValue()).getPort()));
            configuration.setChannelFactory((ProtocolChannelFactory)new ManagementChannelFactory());
            client = ProtocolChannelClient.create((ProtocolChannelClient.Configuration)configuration);
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
        try {
            client.connect((CallbackHandler)new ClientCallbackHandler());
            this.channel = (ManagementChannel)client.openChannel("server");
            this.channel.startReceiving();
        }
        catch (IOException e) {
            throw new StartException("Failed to start remote Host Controller connection", (Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        StreamUtils.safeClose(this.client);
        this.client = null;
        this.channel = null;
    }

    public synchronized ManagementChannel getValue() throws IllegalStateException {
        return this.channel;
    }

    private class ClientCallbackHandler
    implements CallbackHandler {
        private ClientCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback current : callbacks) {
                if (current instanceof RealmCallback) {
                    RealmCallback rcb = (RealmCallback)current;
                    String defaultText = rcb.getDefaultText();
                    rcb.setText(defaultText);
                    continue;
                }
                if (current instanceof RealmChoiceCallback) {
                    throw new UnsupportedCallbackException(current, "Realm choice not currently supported.");
                }
                if (current instanceof NameCallback) {
                    NameCallback ncb = (NameCallback)current;
                    ncb.setName(HostControllerConnectionService.this.serverName);
                    continue;
                }
                if (current instanceof PasswordCallback) {
                    PasswordCallback pcb = (PasswordCallback)current;
                    pcb.setPassword(new String(HostControllerConnectionService.this.authKey).toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(current);
            }
        }
    }
}

