/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module.descriptor;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.module.AdditionalModuleSpecification;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.deployment.module.descriptor.JBossDeploymentStructureParser10;
import org.jboss.as.server.deployment.module.descriptor.JBossDeploymentStructureParser11;
import org.jboss.as.server.deployment.module.descriptor.ModuleStructureSpec;
import org.jboss.as.server.deployment.module.descriptor.ParseResult;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleLoader;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLMapper;
import org.jboss.vfs.VirtualFile;

public class DeploymentStructureDescriptorParser
implements DeploymentUnitProcessor {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.server.deployment.module.deployment-structure-descriptor-processor");
    public static final String[] DEPLOYMENT_STRUCTURE_DESCRIPTOR_LOCATIONS = new String[]{"META-INF/jboss-deployment-structure.xml", "WEB-INF/jboss-deployment-structure.xml"};
    private static final QName ROOT_1_0 = new QName("urn:jboss:deployment-structure:1.0", "jboss-deployment-structure");
    private static final QName ROOT_1_1 = new QName("urn:jboss:deployment-structure:1.1", "jboss-deployment-structure");
    private static final QName ROOT_NO_NAMESPACE = new QName("jboss-deployment-structure");
    private static final XMLInputFactory INPUT_FACTORY = XMLInputFactory.newInstance();
    private final XMLMapper mapper = XMLMapper.Factory.create();

    public DeploymentStructureDescriptorParser() {
        this.mapper.registerRootElement(ROOT_1_0, (XMLElementReader)JBossDeploymentStructureParser10.INSTANCE);
        this.mapper.registerRootElement(ROOT_1_1, (XMLElementReader)JBossDeploymentStructureParser11.INSTANCE);
        this.mapper.registerRootElement(ROOT_NO_NAMESPACE, (XMLElementReader)JBossDeploymentStructureParser11.INSTANCE);
    }

    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ResourceRoot resourceRoot = deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        ServiceModuleLoader moduleLoader = deploymentUnit.getAttachment(Attachments.SERVICE_MODULE_LOADER);
        VirtualFile deploymentFile = null;
        for (String loc : DEPLOYMENT_STRUCTURE_DESCRIPTOR_LOCATIONS) {
            VirtualFile file = resourceRoot.getRoot().getChild(loc);
            if (!file.exists()) continue;
            deploymentFile = file;
            break;
        }
        if (deploymentFile == null) {
            return;
        }
        if (deploymentUnit.getParent() != null) {
            log.warnf("%s in subdeployment ignored. jboss-deployment-structure.xml is only parsed for top level deployments.", (Object)deploymentFile.getPathName());
            return;
        }
        try {
            ModuleStructureSpec rootDeploymentSpecification;
            ParseResult result = this.parse(deploymentFile.getPhysicalFile(), deploymentUnit, moduleLoader);
            ModuleSpecification moduleSpec = deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
            if (result.getEarSubDeploymentsIsolated() != null) {
                moduleSpec.setSubDeploymentModulesIsolated(result.getEarSubDeploymentsIsolated());
            }
            if ((rootDeploymentSpecification = result.getRootDeploymentSpecification()) != null) {
                Map<VirtualFile, ResourceRoot> resourceRoots = this.resourceRoots(deploymentUnit);
                moduleSpec.addUserDependencies(rootDeploymentSpecification.getModuleDependencies());
                moduleSpec.addExclusions(rootDeploymentSpecification.getExclusions());
                moduleSpec.addAliases(rootDeploymentSpecification.getAliases());
                moduleSpec.addModuleSystemDependencies(rootDeploymentSpecification.getSytemDependencies());
                for (ResourceRoot additionalResourceRoot : rootDeploymentSpecification.getResourceRoots()) {
                    ResourceRoot resourceRoot2 = resourceRoots.get(additionalResourceRoot.getRoot());
                    if (resourceRoot2 != null) {
                        resourceRoot2.merge(additionalResourceRoot);
                        continue;
                    }
                    deploymentUnit.addToAttachmentList(Attachments.RESOURCE_ROOTS, additionalResourceRoot);
                }
                for (String classFileTransformer : rootDeploymentSpecification.getClassFileTransformers()) {
                    moduleSpec.addClassFileTransformer(classFileTransformer);
                }
            }
            List<DeploymentUnit> subDeployments = deploymentUnit.getAttachmentList(Attachments.SUB_DEPLOYMENTS);
            HashMap<String, DeploymentUnit> subDeploymentMap = new HashMap<String, DeploymentUnit>();
            for (DeploymentUnit deploymentUnit2 : subDeployments) {
                ResourceRoot subDeploymentRoot = deploymentUnit2.getAttachment(Attachments.DEPLOYMENT_ROOT);
                String path = subDeploymentRoot.getRoot().getPathNameRelativeTo(resourceRoot.getRoot());
                subDeploymentMap.put(path, deploymentUnit2);
            }
            for (Map.Entry entry : result.getSubDeploymentSpecifications().entrySet()) {
                String path = (String)entry.getKey();
                ModuleStructureSpec spec = (ModuleStructureSpec)entry.getValue();
                if (!subDeploymentMap.containsKey(path)) {
                    throw this.subDeploymentNotFound(path, subDeploymentMap.keySet());
                }
                DeploymentUnit subDeployment = (DeploymentUnit)subDeploymentMap.get(path);
                ModuleSpecification subModuleSpec = subDeployment.getAttachment(Attachments.MODULE_SPECIFICATION);
                Map<VirtualFile, ResourceRoot> resourceRoots = this.resourceRoots(subDeployment);
                subModuleSpec.addUserDependencies(spec.getModuleDependencies());
                subModuleSpec.addExclusions(spec.getExclusions());
                subModuleSpec.addAliases(spec.getAliases());
                subModuleSpec.addModuleSystemDependencies(spec.getSytemDependencies());
                for (ResourceRoot additionalResourceRoot : spec.getResourceRoots()) {
                    ResourceRoot existingRoot = resourceRoots.get(additionalResourceRoot.getRoot());
                    if (existingRoot != null) {
                        existingRoot.merge(additionalResourceRoot);
                        continue;
                    }
                    subDeployment.addToAttachmentList(Attachments.RESOURCE_ROOTS, additionalResourceRoot);
                }
                for (String classFileTransformer : spec.getClassFileTransformers()) {
                    subModuleSpec.addClassFileTransformer(classFileTransformer);
                }
                subModuleSpec.setLocalLast(spec.isLocalLast());
            }
            for (ModuleStructureSpec moduleStructureSpec : result.getAdditionalModules()) {
                AdditionalModuleSpecification additional = new AdditionalModuleSpecification(moduleStructureSpec.getModuleIdentifier(), moduleStructureSpec.getResourceRoots());
                additional.addAliases(moduleStructureSpec.getAliases());
                additional.addSystemDependencies(moduleStructureSpec.getModuleDependencies());
                deploymentUnit.addToAttachmentList(Attachments.ADDITIONAL_MODULES, additional);
            }
        }
        catch (IOException e) {
            throw new DeploymentUnitProcessingException(e);
        }
    }

    private Map<VirtualFile, ResourceRoot> resourceRoots(DeploymentUnit deploymentUnit) {
        HashMap<VirtualFile, ResourceRoot> resourceRoots = new HashMap<VirtualFile, ResourceRoot>();
        for (ResourceRoot root : DeploymentUtils.allResourceRoots(deploymentUnit)) {
            resourceRoots.put(root.getRoot(), root);
        }
        return resourceRoots;
    }

    private DeploymentUnitProcessingException subDeploymentNotFound(String path, Collection<String> subDeployments) {
        StringBuilder builder = new StringBuilder();
        builder.append("Sub deployment ");
        builder.append(path);
        builder.append(" in jboss-structure.xml was not found. Available sub deployments: ");
        for (String dep : subDeployments) {
            builder.append(dep);
            builder.append(", ");
        }
        return new DeploymentUnitProcessingException(builder.toString());
    }

    @Override
    public void undeploy(DeploymentUnit context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseResult parse(File file, DeploymentUnit deploymentUnit, ModuleLoader moduleLoader) throws DeploymentUnitProcessingException {
        FileInputStream fis;
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new DeploymentUnitProcessingException("No jboss-deployment-structure.xml file found at " + file);
        }
        try {
            ParseResult parseResult = this.parse(fis, file, deploymentUnit, moduleLoader);
            return parseResult;
        }
        finally {
            DeploymentStructureDescriptorParser.safeClose(fis);
        }
    }

    private void setIfSupported(XMLInputFactory inputFactory, String property, Object value) {
        if (inputFactory.isPropertySupported(property)) {
            inputFactory.setProperty(property, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseResult parse(InputStream source, File file, DeploymentUnit deploymentUnit, ModuleLoader moduleLoader) throws DeploymentUnitProcessingException {
        ParseResult parseResult;
        XMLInputFactory inputFactory = INPUT_FACTORY;
        this.setIfSupported(inputFactory, "javax.xml.stream.isValidating", Boolean.FALSE);
        this.setIfSupported(inputFactory, "javax.xml.stream.supportDTD", Boolean.FALSE);
        XMLStreamReader streamReader = inputFactory.createXMLStreamReader(source);
        try {
            ParseResult result = new ParseResult(moduleLoader, deploymentUnit);
            this.mapper.parseDocument((Object)result, streamReader);
            parseResult = result;
        }
        catch (Throwable throwable) {
            try {
                DeploymentStructureDescriptorParser.safeClose(streamReader);
                throw throwable;
            }
            catch (XMLStreamException e) {
                throw new DeploymentUnitProcessingException("Error loading jboss-structure.xml from " + file.getPath(), e);
            }
        }
        DeploymentStructureDescriptorParser.safeClose(streamReader);
        return parseResult;
    }

    private static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void safeClose(XMLStreamReader streamReader) {
        if (streamReader != null) {
            try {
                streamReader.close();
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
        }
    }
}

