/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.reflect;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;

public class ClassIndex {
    private final Class<?> moduleClass;
    private final DeploymentReflectionIndex deploymentReflectionIndex;
    private volatile Set<Method> classMethods;

    ClassIndex(Class<?> moduleClass, DeploymentReflectionIndex deploymentReflectionIndex) {
        this.moduleClass = moduleClass;
        this.deploymentReflectionIndex = deploymentReflectionIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Method> getClassMethods() {
        if (this.classMethods == null) {
            ClassIndex classIndex = this;
            synchronized (classIndex) {
                if (this.classMethods == null) {
                    Set methods = Collections.newSetFromMap(new IdentityHashMap());
                    for (Class<?> clazz = this.moduleClass; clazz != null; clazz = clazz.getSuperclass()) {
                        methods.addAll(this.deploymentReflectionIndex.getClassIndex(clazz).getMethods());
                    }
                    this.classMethods = methods;
                }
            }
        }
        return this.classMethods;
    }

    public Class<?> getModuleClass() {
        return this.moduleClass;
    }

    public String toString() {
        return "ClassIndex{moduleClass=" + this.moduleClass + " ClassLoader " + this.moduleClass.getClassLoader() + '}';
    }
}

