/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.path;

import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public abstract class AbstractPathService
implements Service<String> {
    private static final ServiceName SERVICE_NAME_BASE = ServiceName.JBOSS.append(new String[]{"server", "path"});
    private String path;

    public static ServiceName pathNameOf(String pathName) {
        if (pathName == null) {
            throw new IllegalArgumentException("pathName is null");
        }
        return SERVICE_NAME_BASE.append(new String[]{pathName});
    }

    public static boolean isAbsoluteUnixOrWindowsPath(String path) {
        int length;
        if (path != null && (length = path.length()) > 0) {
            char c0 = path.charAt(0);
            if (c0 == '/') {
                return true;
            }
            if (length > 1) {
                char c1 = path.charAt(1);
                if (c0 == '\\' && c1 == '\\') {
                    return true;
                }
                if (length > 2 && c1 == ':' && path.charAt(2) == '\\' && AbstractPathService.isDriveLetter(c0)) {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isDriveLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public void start(StartContext context) throws StartException {
        this.path = this.resolvePath();
    }

    public void stop(StopContext context) {
    }

    public String getValue() throws IllegalStateException {
        String path = this.path;
        if (path == null) {
            throw new IllegalStateException();
        }
        return path;
    }

    protected abstract String resolvePath();
}

