/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.DeploymentDescription;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.AbstractParameterValidator;
import org.jboss.as.controller.operations.validation.ChainedParameterValidator;
import org.jboss.as.controller.operations.validation.ListValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersOfValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.DeploymentFileRepository;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.server.deployment.AbstractDeploymentHandler;
import org.jboss.as.server.deployment.DeploymentHandlerUtil;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DeploymentAddHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "add";
    protected final ContentRepository contentRepository;
    protected final ParametersValidator validator = new ParametersValidator();
    protected final ParametersValidator unmanagedContentValidator = new ParametersValidator();
    protected final ParametersValidator managedContentValidator = new ParametersValidator();

    static ModelNode getOperation(ModelNode address, ModelNode state) {
        ModelNode op = Util.getEmptyOperation((String)OPERATION_NAME, (ModelNode)address);
        op.get("runtime-name").set(state.get("runtime-name"));
        op.get("content").set(state.get("content"));
        if (state.hasDefined("enabled")) {
            op.get("enabled").set(state.get("enabled"));
        }
        return op;
    }

    protected DeploymentAddHandler(ContentRepository contentRepository) {
        assert (contentRepository != null) : "Null contentRepository";
        this.contentRepository = contentRepository;
        this.validator.registerValidator("runtime-name", (ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false));
        this.validator.registerValidator("enabled", (ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN, true));
        ParametersValidator contentValidator = new ParametersValidator();
        contentValidator.registerValidator("hash", (ParameterValidator)new ModelTypeValidator(ModelType.BYTES, true));
        contentValidator.registerValidator("archive", (ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN, true));
        contentValidator.registerValidator("path", (ParameterValidator)new StringLengthValidator(1, true));
        contentValidator.registerValidator("relative-to", (ParameterValidator)new ModelTypeValidator(ModelType.STRING, true));
        contentValidator.registerValidator("input-stream-index", (ParameterValidator)new ModelTypeValidator(ModelType.INT, true));
        contentValidator.registerValidator("bytes", (ParameterValidator)new ModelTypeValidator(ModelType.BYTES, true));
        contentValidator.registerValidator("url", (ParameterValidator)new StringLengthValidator(1, true));
        this.validator.registerValidator("content", ChainedParameterValidator.chain((ParameterValidator[])new ParameterValidator[]{new ListValidator((ParameterValidator)new ParametersOfValidator(contentValidator)), new AbstractParameterValidator(){

            public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
                AbstractDeploymentHandler.validateOnePieceOfContent(value);
            }
        }}));
        this.managedContentValidator.registerValidator("hash", (ParameterValidator)new ModelTypeValidator(ModelType.BYTES));
        this.unmanagedContentValidator.registerValidator("archive", (ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN));
        this.unmanagedContentValidator.registerValidator("path", (ParameterValidator)new StringLengthValidator(1));
    }

    public static DeploymentAddHandler createForStandalone(ContentRepository contentRepository) {
        return new DeploymentAddHandler(contentRepository);
    }

    public static DeploymentAddHandler createForDomainServer(ContentRepository contentRepository, DeploymentFileRepository remoteFileRepository) {
        return new DomainServerDeploymentAddHandler(contentRepository, remoteFileRepository);
    }

    public ModelNode getModelDescription(Locale locale) {
        return DeploymentDescription.getAddDeploymentOperation((Locale)locale, (boolean)true);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        DeploymentHandlerUtil.ContentItem contentItem;
        this.validator.validate(operation);
        ModelNode opAddr = operation.get("address");
        PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
        String name = address.getLastElement().getValue();
        String runtimeName = operation.hasDefined("runtime-name") ? operation.get("runtime-name").asString() : name;
        ModelNode content = operation.require("content").clone();
        ModelNode contentItemNode = content.require(0);
        if (contentItemNode.hasDefined("hash")) {
            this.managedContentValidator.validate(contentItemNode);
            byte[] hash = contentItemNode.require("hash").asBytes();
            contentItem = this.addFromHash(hash, contentItemNode);
        } else {
            contentItem = AbstractDeploymentHandler.hasValidContentAdditionParameterDefined(contentItemNode) ? this.addFromContentAdditionParameter(context, contentItemNode) : this.addUnmanaged(contentItemNode);
        }
        Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
        ModelNode subModel = resource.getModel();
        subModel.get("name").set(name);
        subModel.get("runtime-name").set(runtimeName);
        subModel.get("content").set(content);
        subModel.get("enabled").set(operation.has("enabled") && operation.get("enabled").asBoolean());
        subModel.get("persistent").set(!operation.hasDefined("persistent") || operation.get("persistent").asBoolean());
        if (subModel.get("enabled").asBoolean() && context.getType() == OperationContext.Type.SERVER) {
            DeploymentHandlerUtil.deploy(context, runtimeName, name, contentItem);
        }
        context.completeStep();
    }

    DeploymentHandlerUtil.ContentItem addFromHash(byte[] hash, ModelNode contentItemNode) throws OperationFailedException {
        if (!this.contentRepository.hasContent(hash)) {
            throw ServerMessages.MESSAGES.noSuchDeploymentContent(HashUtil.bytesToHexString((byte[])hash));
        }
        return new DeploymentHandlerUtil.ContentItem(hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DeploymentHandlerUtil.ContentItem addFromContentAdditionParameter(OperationContext context, ModelNode contentItemNode) throws OperationFailedException {
        byte[] hash;
        InputStream in = AbstractDeploymentHandler.getInputStream(context, contentItemNode);
        try {
            try {
                hash = this.contentRepository.addContent(in);
            }
            catch (IOException e) {
                throw AbstractDeploymentHandler.createFailureException(e.toString());
            }
        }
        finally {
            StreamUtils.safeClose((Closeable)in);
        }
        contentItemNode.clear();
        contentItemNode.get("hash").set(hash);
        return new DeploymentHandlerUtil.ContentItem(hash);
    }

    DeploymentHandlerUtil.ContentItem addUnmanaged(ModelNode contentItemNode) throws OperationFailedException {
        this.unmanagedContentValidator.validate(contentItemNode);
        String path = contentItemNode.require("path").asString();
        String relativeTo = AbstractDeploymentHandler.asString(contentItemNode, "relative-to");
        boolean archive = contentItemNode.require("archive").asBoolean();
        return new DeploymentHandlerUtil.ContentItem(path, relativeTo, archive);
    }

    private static class DomainServerDeploymentAddHandler
    extends DeploymentAddHandler {
        final DeploymentFileRepository remoteFileRepository;

        DomainServerDeploymentAddHandler(ContentRepository contentRepository, DeploymentFileRepository remoteFileRepository) {
            super(contentRepository);
            assert (remoteFileRepository != null) : "Null remoteFileRepository";
            this.remoteFileRepository = remoteFileRepository;
        }

        @Override
        DeploymentHandlerUtil.ContentItem addFromHash(byte[] hash, ModelNode contentItemNode) throws OperationFailedException {
            this.remoteFileRepository.getDeploymentFiles(hash);
            return super.addFromHash(hash, contentItemNode);
        }

        @Override
        DeploymentHandlerUtil.ContentItem addFromContentAdditionParameter(OperationContext context, ModelNode contentItemNode) throws OperationFailedException {
            throw ServerMessages.MESSAGES.onlyHashAllowedForDeploymentFullReplaceInDomainServer(contentItemNode);
        }
    }
}

