/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.util.Locale;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.DeploymentDescription;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.DeploymentFileRepository;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.server.deployment.AbstractDeploymentHandler;
import org.jboss.as.server.deployment.DeploymentHandlerUtil;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DeploymentReplaceHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "replace-deployment";
    private final ContentRepository contentRepository;
    private final ParametersValidator validator = new ParametersValidator();
    private final ParametersValidator unmanagedContentValidator = new ParametersValidator();
    private final ParametersValidator managedContentValidator = new ParametersValidator();

    protected DeploymentReplaceHandler(ContentRepository contentRepository) {
        assert (contentRepository != null) : "Null contentRepository";
        this.contentRepository = contentRepository;
        this.validator.registerValidator("name", (ParameterValidator)new StringLengthValidator(1));
        this.validator.registerValidator("to-replace", (ParameterValidator)new StringLengthValidator(1));
        this.managedContentValidator.registerValidator("hash", (ParameterValidator)new ModelTypeValidator(ModelType.BYTES));
        this.unmanagedContentValidator.registerValidator("archive", (ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN));
        this.unmanagedContentValidator.registerValidator("path", (ParameterValidator)new StringLengthValidator(1));
    }

    public static DeploymentReplaceHandler createForStandalone(ContentRepository contentRepository) {
        return new DeploymentReplaceHandler(contentRepository);
    }

    public static DeploymentReplaceHandler createForDomainServer(ContentRepository contentRepository, DeploymentFileRepository remoteFileRepository) {
        return new DomainServerDeploymentReplaceHandler(contentRepository, remoteFileRepository);
    }

    public ModelNode getModelDescription(Locale locale) {
        return DeploymentDescription.getReplaceDeploymentOperation((Locale)locale);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode deployNode;
        String runtimeName;
        this.validator.validate(operation);
        String name = operation.require("name").asString();
        String toReplace = operation.require("to-replace").asString();
        if (name.equals(toReplace)) {
            throw ServerMessages.MESSAGES.cannotReplaceDeployment(OPERATION_NAME, "name", "to-replace", "redeploy", "full-replace-deployment");
        }
        PathElement deployPath = PathElement.pathElement((String)"deployment", (String)name);
        PathElement replacePath = PathElement.pathElement((String)"deployment", (String)toReplace);
        Resource root = context.readResource(PathAddress.EMPTY_ADDRESS);
        if (!root.hasChild(replacePath)) {
            throw ServerMessages.MESSAGES.noSuchDeployment(toReplace);
        }
        ModelNode replaceNode = context.readResourceForUpdate(PathAddress.pathAddress((PathElement[])new PathElement[]{replacePath})).getModel();
        String replacedName = replaceNode.require("runtime-name").asString();
        if (!root.hasChild(deployPath)) {
            if (!operation.hasDefined("content")) {
                throw ServerMessages.MESSAGES.noSuchDeployment(name);
            }
            ModelNode content = operation.require("content").clone();
            ModelNode contentItemNode = content.require(0);
            if (contentItemNode.hasDefined("hash")) {
                this.managedContentValidator.validate(contentItemNode);
                byte[] hash = contentItemNode.require("hash").asBytes();
                this.addFromHash(hash);
            } else {
                this.unmanagedContentValidator.validate(contentItemNode);
            }
            runtimeName = operation.hasDefined("runtime-name") ? operation.get("runtime-name").asString() : replacedName;
            Resource deployResource = context.createResource(PathAddress.pathAddress((PathElement[])new PathElement[]{deployPath}));
            deployNode = deployResource.getModel();
            deployNode.get("runtime-name").set(runtimeName);
            deployNode.get("content").set(content);
        } else {
            deployNode = context.readResourceForUpdate(PathAddress.pathAddress((PathElement[])new PathElement[]{deployPath})).getModel();
            if (deployNode.get("enabled").asBoolean()) {
                throw ServerMessages.MESSAGES.deploymentAlreadyStarted(toReplace);
            }
            runtimeName = deployNode.require("runtime-name").asString();
        }
        deployNode.get("enabled").set(true);
        replaceNode.get("enabled").set(false);
        DeploymentHandlerUtil.ContentItem[] contents = AbstractDeploymentHandler.getContents(deployNode.require("content"));
        DeploymentHandlerUtil.replace(context, replaceNode, runtimeName, name, replacedName, contents);
        context.completeStep();
    }

    protected void addFromHash(byte[] hash) throws OperationFailedException {
        if (!this.contentRepository.hasContent(hash)) {
            throw ServerMessages.MESSAGES.noSuchDeploymentContent(HashUtil.bytesToHexString((byte[])hash));
        }
    }

    private static class DomainServerDeploymentReplaceHandler
    extends DeploymentReplaceHandler {
        final DeploymentFileRepository remoteFileRepository;

        public DomainServerDeploymentReplaceHandler(ContentRepository contentRepository, DeploymentFileRepository remoteFileRepository) {
            super(contentRepository);
            assert (remoteFileRepository != null) : "Null remoteFileRepository";
            this.remoteFileRepository = remoteFileRepository;
        }

        @Override
        protected void addFromHash(byte[] hash) throws OperationFailedException {
            this.remoteFileRepository.getDeploymentFiles(hash);
            super.addFromHash(hash);
        }
    }
}

