/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.net;

import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.resource.AbstractSocketBindingResourceDefinition;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.server.services.net.AbstractBindingWriteHandler;
import org.jboss.as.server.services.net.BindingAddHandler;
import org.jboss.dmr.ModelNode;

public class ClientMappingsHandler
extends AbstractBindingWriteHandler {
    public static final ClientMappingsHandler INSTANCE = new ClientMappingsHandler();

    private ClientMappingsHandler() {
        super(AbstractSocketBindingResourceDefinition.CLIENT_MAPPINGS.getValidator());
    }

    @Override
    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    @Override
    void handleRuntimeChange(ModelNode operation, String attributeName, ModelNode attributeValue, SocketBinding binding) throws OperationFailedException {
        binding.setClientMappings(BindingAddHandler.parseClientMappings(attributeValue));
    }

    @Override
    void handleRuntimeRollback(ModelNode operation, String attributeName, ModelNode attributeValue, SocketBinding binding) {
        try {
            binding.setClientMappings(BindingAddHandler.parseClientMappings(attributeValue));
        }
        catch (OperationFailedException e) {
            ControllerMessages.MESSAGES.failedToRecoverServices(e);
        }
    }
}

