/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.server.deployment.AbstractDeploymentUnitService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentModelUtils;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitImpl;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.services.security.AbstractVaultReader;
import org.jboss.msc.service.ServiceRegistry;

public class SubDeploymentUnitService
extends AbstractDeploymentUnitService {
    private final ResourceRoot deploymentRoot;
    private final DeploymentUnit parent;
    private final ImmutableManagementResourceRegistration registration;
    private final ManagementResourceRegistration mutableRegistration;
    private final ServiceVerificationHandler serviceVerificationHandler;
    private Resource resource;
    private final AbstractVaultReader vaultReader;

    public SubDeploymentUnitService(ResourceRoot deploymentRoot, DeploymentUnit parent, ImmutableManagementResourceRegistration registration, ManagementResourceRegistration mutableRegistration, Resource resource, ServiceVerificationHandler serviceVerificationHandler, AbstractVaultReader vaultReader) {
        this.serviceVerificationHandler = serviceVerificationHandler;
        if (deploymentRoot == null) {
            throw ServerMessages.MESSAGES.deploymentRootRequired();
        }
        this.deploymentRoot = deploymentRoot;
        if (parent == null) {
            throw ServerMessages.MESSAGES.subdeploymentsRequireParent();
        }
        this.parent = parent;
        this.registration = registration;
        this.mutableRegistration = mutableRegistration;
        this.resource = resource;
        this.vaultReader = vaultReader;
    }

    @Override
    protected DeploymentUnit createAndInitializeDeploymentUnit(ServiceRegistry registry) {
        String deploymentName = this.deploymentRoot.getRootName();
        DeploymentUnitImpl deploymentUnit = new DeploymentUnitImpl(this.parent, deploymentName, registry);
        deploymentUnit.putAttachment(Attachments.DEPLOYMENT_ROOT, this.deploymentRoot);
        deploymentUnit.putAttachment(Attachments.MODULE_SPECIFICATION, new ModuleSpecification());
        deploymentUnit.putAttachment(DeploymentModelUtils.REGISTRATION_ATTACHMENT, this.registration);
        deploymentUnit.putAttachment(DeploymentModelUtils.MUTABLE_REGISTRATION_ATTACHMENT, this.mutableRegistration);
        deploymentUnit.putAttachment(DeploymentModelUtils.DEPLOYMENT_RESOURCE, this.resource);
        deploymentUnit.putAttachment(Attachments.SERVICE_VERIFICATION_HANDLER, this.serviceVerificationHandler);
        deploymentUnit.putAttachment(Attachments.VAULT_READER_ATTACHMENT_KEY, this.vaultReader);
        this.resource = null;
        return deploymentUnit;
    }
}

