/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.subsystem.test;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.validation.OperationValidator;
import org.jboss.as.subsystem.test.AbstractSubsystemTest;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceContainer;

public class KernelServices {
    private volatile ServiceContainer container;
    private final ModelController controller;
    private final AbstractSubsystemTest.StringConfigurationPersister persister;
    private final OperationValidator operationValidator;

    KernelServices(ServiceContainer container, ModelController controller, AbstractSubsystemTest.StringConfigurationPersister persister, OperationValidator operationValidator) {
        this.container = container;
        this.controller = controller;
        this.persister = persister;
        this.operationValidator = operationValidator;
    }

    public ServiceContainer getContainer() {
        return this.container;
    }

    public ModelNode executeOperation(ModelNode operation) {
        return this.controller.execute(operation, null, ModelController.OperationTransactionControl.COMMIT, null);
    }

    public String getPersistedSubsystemXml() {
        return this.persister.marshalled;
    }

    public ModelNode readWholeModel() {
        ModelNode op = new ModelNode();
        op.get("operation").set("read-resource");
        op.get("address").set(PathAddress.EMPTY_ADDRESS.toModelNode());
        op.get("recursive").set(true);
        ModelNode result = this.executeOperation(op);
        return AbstractSubsystemTest.checkResultAndGetContents(result);
    }

    public void validateOperations(List<ModelNode> operations) {
        this.operationValidator.validateOperations(operations);
    }

    public void validateOperation(ModelNode operation) {
        this.operationValidator.validateOperation(operation);
    }

    public void shutdown() {
        if (this.container != null) {
            this.container.shutdown();
            try {
                this.container.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.container = null;
        }
    }
}

