/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.subsystem.test;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import junit.framework.Assert;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.OverrideDescriptionProvider;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.extension.SubsystemInformation;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.SubsystemXmlWriterRegistry;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.SubsystemDescriptionDump;
import org.jboss.as.controller.transform.TransformerRegistry;
import org.jboss.as.model.test.ChildFirstClassLoaderBuilder;
import org.jboss.as.model.test.ModelFixer;
import org.jboss.as.model.test.ModelTestBootOperationsBuilder;
import org.jboss.as.model.test.ModelTestKernelServices;
import org.jboss.as.model.test.ModelTestModelControllerService;
import org.jboss.as.model.test.ModelTestParser;
import org.jboss.as.model.test.ModelTestUtils;
import org.jboss.as.model.test.StringConfigurationPersister;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.AdditionalParsers;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.as.subsystem.test.KernelServicesBuilder;
import org.jboss.as.subsystem.test.KernelServicesImpl;
import org.jboss.as.subsystem.test.LegacyKernelServicesInitializer;
import org.jboss.as.subsystem.test.ModelDescriptionValidator;
import org.jboss.as.subsystem.test.TestParser;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLMapper;
import org.xnio.IoUtils;

final class SubsystemTestDelegate {
    private final String TEST_NAMESPACE = "urn.org.jboss.test:1.0";
    private static final ModelNode SUCCESS = new ModelNode();
    private final Class<?> testClass;
    private final List<KernelServices> kernelServices = new ArrayList<KernelServices>();
    protected final String mainSubsystemName;
    private final Extension mainExtension;
    private final Comparator<PathAddress> removeOrderComparator;
    private ExtensionRegistry extensionParsingRegistry;
    private ModelTestParser testParser;
    private boolean addedExtraParsers;
    private XMLMapper xmlMapper;
    private final ManagementResourceRegistration MOCK_RESOURCE_REG = new ManagementResourceRegistration(){

        public boolean isRuntimeOnly() {
            return false;
        }

        public boolean isRemote() {
            return false;
        }

        public OperationEntry getOperationEntry(PathAddress address, String operationName) {
            return null;
        }

        public OperationStepHandler getOperationHandler(PathAddress address, String operationName) {
            return null;
        }

        public DescriptionProvider getOperationDescription(PathAddress address, String operationName) {
            return null;
        }

        public Set<OperationEntry.Flag> getOperationFlags(PathAddress address, String operationName) {
            return null;
        }

        public Set<String> getAttributeNames(PathAddress address) {
            return null;
        }

        public AttributeAccess getAttributeAccess(PathAddress address, String attributeName) {
            return null;
        }

        public Set<String> getChildNames(PathAddress address) {
            return null;
        }

        public Set<PathElement> getChildAddresses(PathAddress address) {
            return null;
        }

        public DescriptionProvider getModelDescription(PathAddress address) {
            return null;
        }

        public Map<String, OperationEntry> getOperationDescriptions(PathAddress address, boolean inherited) {
            return null;
        }

        public ProxyController getProxyController(PathAddress address) {
            return null;
        }

        public Set<ProxyController> getProxyControllers(PathAddress address) {
            return null;
        }

        public ManagementResourceRegistration getOverrideModel(String name) {
            return null;
        }

        public ManagementResourceRegistration getSubModel(PathAddress address) {
            return null;
        }

        public ManagementResourceRegistration registerSubModel(PathElement address, DescriptionProvider descriptionProvider) {
            return SubsystemTestDelegate.this.MOCK_RESOURCE_REG;
        }

        public ManagementResourceRegistration registerSubModel(ResourceDefinition resourceDefinition) {
            return SubsystemTestDelegate.this.MOCK_RESOURCE_REG;
        }

        public void unregisterSubModel(PathElement address) {
        }

        public boolean isAllowsOverride() {
            return true;
        }

        public void setRuntimeOnly(boolean runtimeOnly) {
        }

        public ManagementResourceRegistration registerOverrideModel(String name, OverrideDescriptionProvider descriptionProvider) {
            return SubsystemTestDelegate.this.MOCK_RESOURCE_REG;
        }

        public void unregisterOverrideModel(String name) {
        }

        public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider) {
        }

        public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, EnumSet<OperationEntry.Flag> flags) {
        }

        public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, boolean inherited) {
        }

        public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, boolean inherited, OperationEntry.EntryType entryType) {
        }

        public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, boolean inherited, EnumSet<OperationEntry.Flag> flags) {
        }

        public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, boolean inherited, OperationEntry.EntryType entryType, EnumSet<OperationEntry.Flag> flags) {
        }

        public void registerOperationHandler(OperationDefinition definition, OperationStepHandler handler) {
        }

        public void registerOperationHandler(OperationDefinition definition, OperationStepHandler handler, boolean inherited) {
        }

        public void unregisterOperationHandler(String operationName) {
        }

        public void registerReadWriteAttribute(String attributeName, OperationStepHandler readHandler, OperationStepHandler writeHandler, AttributeAccess.Storage storage) {
        }

        public void registerReadWriteAttribute(String attributeName, OperationStepHandler readHandler, OperationStepHandler writeHandler, EnumSet<AttributeAccess.Flag> flags) {
        }

        public void registerReadWriteAttribute(AttributeDefinition definition, OperationStepHandler readHandler, OperationStepHandler writeHandler) {
        }

        public void registerReadOnlyAttribute(String attributeName, OperationStepHandler readHandler, AttributeAccess.Storage storage) {
        }

        public void registerReadOnlyAttribute(String attributeName, OperationStepHandler readHandler, EnumSet<AttributeAccess.Flag> flags) {
        }

        public void registerReadOnlyAttribute(AttributeDefinition definition, OperationStepHandler readHandler) {
        }

        public void registerMetric(String attributeName, OperationStepHandler metricHandler) {
        }

        public void registerMetric(AttributeDefinition definition, OperationStepHandler metricHandler) {
        }

        public void registerMetric(String attributeName, OperationStepHandler metricHandler, EnumSet<AttributeAccess.Flag> flags) {
        }

        public void unregisterAttribute(String attributeName) {
        }

        public void registerProxyController(PathElement address, ProxyController proxyController) {
        }

        public void unregisterProxyController(PathElement address) {
        }

        public void registerAlias(PathElement address, AliasEntry alias) {
        }

        public void unregisterAlias(PathElement address) {
        }

        public AliasEntry getAliasEntry() {
            return null;
        }

        public boolean isAlias() {
            return false;
        }
    };

    SubsystemTestDelegate(Class<?> testClass, String mainSubsystemName, Extension mainExtension, Comparator<PathAddress> removeOrderComparator) {
        this.testClass = testClass;
        this.mainSubsystemName = mainSubsystemName;
        this.mainExtension = mainExtension;
        this.removeOrderComparator = removeOrderComparator;
    }

    String getMainSubsystemName() {
        return this.mainSubsystemName;
    }

    void initializeParser() throws Exception {
        this.xmlMapper = XMLMapper.Factory.create();
        this.extensionParsingRegistry = new ExtensionRegistry(this.getProcessType(), new RunningModeControl(RunningMode.NORMAL));
        this.testParser = new TestParser(this.mainSubsystemName, this.extensionParsingRegistry);
        this.xmlMapper.registerRootElement(new QName("urn.org.jboss.test:1.0", "test"), (XMLElementReader)this.testParser);
        this.mainExtension.initializeParsers(this.extensionParsingRegistry.getExtensionParsingContext("Test", this.xmlMapper));
        this.addedExtraParsers = false;
    }

    void cleanup() throws Exception {
        for (KernelServices kernelServices : this.kernelServices) {
            try {
                kernelServices.shutdown();
            }
            catch (Exception exception) {}
        }
        this.kernelServices.clear();
        this.xmlMapper = null;
        this.extensionParsingRegistry = null;
        this.testParser = null;
    }

    Extension getMainExtension() {
        return this.mainExtension;
    }

    List<ModelNode> parse(String subsystemXml) throws XMLStreamException {
        return this.parse(null, subsystemXml);
    }

    List<ModelNode> parse(AdditionalParsers additionalParsers, String subsystemXml) throws XMLStreamException {
        String xml = "<test xmlns=\"urn.org.jboss.test:1.0\">" + subsystemXml + "</test>";
        XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(xml));
        this.addAdditionalParsers(additionalParsers);
        ArrayList<ModelNode> operationList = new ArrayList<ModelNode>();
        this.xmlMapper.parseDocument(operationList, reader);
        return operationList;
    }

    String outputModel(ModelNode model) throws Exception {
        StringConfigurationPersister persister = new StringConfigurationPersister(Collections.emptyList(), (XMLElementWriter)this.testParser, true);
        ExtensionRegistry outputExtensionRegistry = new ExtensionRegistry(ProcessType.HOST_CONTROLLER, new RunningModeControl(RunningMode.NORMAL));
        outputExtensionRegistry.setSubsystemParentResourceRegistrations(this.MOCK_RESOURCE_REG, this.MOCK_RESOURCE_REG);
        outputExtensionRegistry.setWriterRegistry((SubsystemXmlWriterRegistry)persister);
        Extension extension = (Extension)this.mainExtension.getClass().newInstance();
        extension.initialize(outputExtensionRegistry.getExtensionContext("Test", false));
        ConfigurationPersister.PersistenceResource resource = persister.store(model, Collections.emptySet());
        resource.commit();
        return persister.getMarshalled();
    }

    KernelServices installInController(String subsystemXml) throws Exception {
        return this.createKernelServicesBuilder(null).setSubsystemXml(subsystemXml).build();
    }

    KernelServices installInController(AdditionalInitialization additionalInit, String subsystemXml) throws Exception {
        return this.createKernelServicesBuilder(additionalInit).setSubsystemXml(subsystemXml).build();
    }

    KernelServices installInController(List<ModelNode> bootOperations) throws Exception {
        return this.createKernelServicesBuilder(null).setBootOperations(bootOperations).build();
    }

    KernelServices installInController(AdditionalInitialization additionalInit, List<ModelNode> bootOperations) throws Exception {
        return this.createKernelServicesBuilder(additionalInit).setBootOperations(bootOperations).build();
    }

    KernelServicesBuilder createKernelServicesBuilder(AdditionalInitialization additionalInit) {
        return new KernelServicesBuilderImpl(additionalInit);
    }

    ProcessType getProcessType() {
        return ProcessType.EMBEDDED_SERVER;
    }

    void assertRemoveSubsystemResources(KernelServices kernelServices) {
        this.assertRemoveSubsystemResources(kernelServices, null);
    }

    void assertRemoveSubsystemResources(KernelServices kernelServices, Set<PathAddress> ignoredChildAddresses) {
        if (ignoredChildAddresses == null) {
            ignoredChildAddresses = Collections.emptySet();
        } else {
            PathAddress subsystem = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)this.mainSubsystemName)});
            Assert.assertFalse((String)"Cannot exclude removal of subsystem itself", (boolean)ignoredChildAddresses.contains(subsystem));
        }
        Resource rootResource = ModelTestModelControllerService.grabRootResource((ModelTestKernelServices)kernelServices);
        ArrayList<PathAddress> addresses = new ArrayList<PathAddress>();
        PathAddress pathAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)this.mainSubsystemName)});
        Resource subsystemResource = rootResource.getChild(pathAddress.getLastElement());
        Assert.assertNotNull((Object)subsystemResource);
        addresses.add(pathAddress);
        this.getAllChildAddressesForRemove(pathAddress, addresses, subsystemResource);
        if (this.removeOrderComparator != null) {
            Collections.sort(addresses, this.removeOrderComparator);
        }
        ModelNode composite = new ModelNode();
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        composite.get("rollback-on-runtime-failure").set(true);
        ListIterator iterator = addresses.listIterator(addresses.size());
        while (iterator.hasPrevious()) {
            PathAddress cur = (PathAddress)iterator.previous();
            if (ignoredChildAddresses.contains(cur)) continue;
            ModelNode remove = new ModelNode();
            remove.get("operation").set("remove");
            remove.get("address").set(cur.toModelNode());
            composite.get("steps").add(remove);
        }
        kernelServices.executeOperation(composite, new InputStream[0]);
        ModelNode model = kernelServices.readWholeModel().get(new String[]{"subsystem", this.mainSubsystemName});
        Assert.assertFalse((String)("Subsystem resources were not removed " + model), (boolean)model.isDefined());
    }

    private void getAllChildAddressesForRemove(PathAddress address, List<PathAddress> addresses, Resource resource) {
        ArrayList<PathElement> childElements = new ArrayList<PathElement>();
        for (String type : resource.getChildTypes()) {
            for (String childName : resource.getChildrenNames(type)) {
                PathElement element = PathElement.pathElement((String)type, (String)childName);
                childElements.add(element);
            }
        }
        for (PathElement childElement : childElements) {
            addresses.add(address.append(new PathElement[]{childElement}));
        }
        for (PathElement childElement : childElements) {
            this.getAllChildAddressesForRemove(address.append(new PathElement[]{childElement}), addresses, resource.getChild(childElement));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    void generateLegacySubsystemResourceRegistrationDmr(KernelServices kernelServices, ModelVersion modelVersion) throws IOException {
        KernelServices legacy = (KernelServices)kernelServices.getLegacyServices(modelVersion);
        PathAddress pathAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)this.mainSubsystemName)});
        ModelNode desc = SubsystemDescriptionDump.readFullModelDescription((PathAddress)pathAddress, (ImmutableManagementResourceRegistration)legacy.getRootRegistration().getSubModel(pathAddress));
        File file = new File("target/classes").getAbsoluteFile();
        Assert.assertTrue((boolean)file.exists());
        for (String part : TransformerRegistry.class.getPackage().getName().split("\\.")) {
            if ((file = new File(file, part)).exists()) continue;
            file.mkdir();
        }
        PrintWriter pw = new PrintWriter(new File(file, this.mainSubsystemName + "-" + modelVersion.getMajor() + "." + modelVersion.getMinor() + "." + modelVersion.getMicro() + ".dmr"));
        try {
            desc.writeString(pw, false);
        }
        finally {
            IoUtils.safeClose((Closeable)pw);
        }
    }

    ModelNode checkSubsystemModelTransformation(KernelServices kernelServices, ModelVersion modelVersion, ModelFixer legacyModelFixer) throws IOException {
        KernelServices legacy = (KernelServices)kernelServices.getLegacyServices(modelVersion);
        ModelNode legacyModel = legacy.readWholeModel();
        ModelNode legacySubsystem = legacyModel.require("subsystem");
        legacySubsystem = legacySubsystem.require(this.mainSubsystemName);
        if (legacyModelFixer != null) {
            legacySubsystem = legacyModelFixer.fixModel(legacySubsystem);
        }
        ModelNode transformed = kernelServices.readTransformedModel(modelVersion).get(new String[]{"subsystem", this.mainSubsystemName});
        ModelTestUtils.compare((ModelNode)legacySubsystem, (ModelNode)transformed, (boolean)true);
        ResourceDefinition rd = TransformerRegistry.loadSubsystemDefinition((String)this.mainSubsystemName, (ModelVersion)modelVersion);
        Assert.assertNotNull((String)("Could not load legacy dmr for subsystem '" + this.mainSubsystemName + "' version: '" + modelVersion + "' please add it"), (Object)rd);
        ManagementResourceRegistration rr = ManagementResourceRegistration.Factory.create((ResourceDefinition)rd);
        ModelTestUtils.checkModelAgainstDefinition((ModelNode)transformed, (ManagementResourceRegistration)rr);
        return legacyModel;
    }

    void addAdditionalParsers(AdditionalParsers additionalParsers) {
        if (additionalParsers != null && !this.addedExtraParsers) {
            additionalParsers.addParsers(this.extensionParsingRegistry, this.xmlMapper);
            this.addedExtraParsers = true;
        }
    }

    private ExtensionRegistry cloneExtensionRegistry(AdditionalInitialization additionalInit) {
        ExtensionRegistry clone = new ExtensionRegistry(additionalInit.getProcessType(), new RunningModeControl(additionalInit.getExtensionRegistryRunningMode()));
        for (String extension : this.extensionParsingRegistry.getExtensionModuleNames()) {
            ExtensionParsingContext epc = clone.getExtensionParsingContext(extension, null);
            for (Map.Entry entry : this.extensionParsingRegistry.getAvailableSubsystems(extension).entrySet()) {
                for (String namespace : ((SubsystemInformation)entry.getValue()).getXMLNamespaces()) {
                    epc.setSubsystemXmlMapping((String)entry.getKey(), namespace, null);
                }
            }
        }
        return clone;
    }

    private void validateDescriptionProviders(AdditionalInitialization additionalInit, KernelServices kernelServices) {
        ModelDescriptionValidator.ValidationConfiguration arbitraryDescriptors = additionalInit.getModelValidationConfiguration();
        ModelNode address = new ModelNode();
        address.setEmptyList();
        address.add("subsystem", this.mainSubsystemName);
        ModelNode op = new ModelNode();
        op.get("operation").set("read-resource-description");
        op.get("address").set(address);
        op.get("recursive").set(true);
        op.get("inherited").set(false);
        op.get("operations").set(true);
        op.get("include-aliases").set(true);
        ModelNode result = kernelServices.executeOperation(op, new InputStream[0]);
        if (result.hasDefined("failure-description")) {
            throw new RuntimeException(result.get("failure-description").toString());
        }
        ModelNode model = result.get("result");
        ModelDescriptionValidator validator = new ModelDescriptionValidator(address, model, arbitraryDescriptors);
        List<ModelDescriptionValidator.ValidationFailure> validationMessages = validator.validateResource();
        if (validationMessages.size() > 0) {
            StringBuilder builder = new StringBuilder("VALIDATION ERRORS IN MODEL:");
            for (ModelDescriptionValidator.ValidationFailure failure : validationMessages) {
                builder.append((Object)failure);
                builder.append("\n");
            }
            if (arbitraryDescriptors != null) {
                Assert.fail((String)("Failed due to validation errors in the model. Please fix :-) " + builder.toString()));
            }
        }
    }

    static {
        SUCCESS.get("outcome").set("success");
        SUCCESS.get("result");
        SUCCESS.protect();
    }

    private class LegacyKernelServiceInitializerImpl
    implements LegacyKernelServicesInitializer {
        private final AdditionalInitialization additionalInit;
        private String extensionClassName;
        private ModelVersion modelVersion;
        ChildFirstClassLoaderBuilder classLoaderBuilder = new ChildFirstClassLoaderBuilder();
        private boolean persistXml = true;

        public LegacyKernelServiceInitializerImpl(AdditionalInitialization additionalInit, ModelVersion modelVersion) {
            this.additionalInit = additionalInit == null ? AdditionalInitialization.MANAGEMENT : additionalInit;
            this.modelVersion = modelVersion;
        }

        @Override
        public LegacyKernelServicesInitializer setExtensionClassName(String extensionClassName) {
            this.extensionClassName = extensionClassName;
            return this;
        }

        @Override
        public LegacyKernelServicesInitializer addURL(URL url) {
            this.classLoaderBuilder.addURL(url);
            return this;
        }

        @Override
        public LegacyKernelServicesInitializer addSimpleResourceURL(String resource) throws MalformedURLException {
            this.classLoaderBuilder.addSimpleResourceURL(resource);
            return this;
        }

        @Override
        public LegacyKernelServicesInitializer addMavenResourceURL(String artifactGav) throws MalformedURLException {
            this.classLoaderBuilder.addMavenResourceURL(artifactGav);
            return this;
        }

        @Override
        public LegacyKernelServiceInitializerImpl addParentFirstClassPattern(String pattern) {
            this.classLoaderBuilder.addParentFirstClassPattern(pattern);
            return this;
        }

        @Override
        public LegacyKernelServiceInitializerImpl addChildFirstClassPattern(String pattern) {
            this.classLoaderBuilder.addChildFirstClassPattern(pattern);
            return this;
        }

        private KernelServicesImpl install(List<ModelNode> bootOperations) throws Exception {
            ClassLoader legacyCl = this.classLoaderBuilder.build();
            Class<?> clazz = legacyCl.loadClass(this.extensionClassName != null ? this.extensionClassName : SubsystemTestDelegate.this.mainExtension.getClass().getName());
            Assert.assertEquals((Object)legacyCl, (Object)clazz.getClassLoader());
            Assert.assertTrue((boolean)Extension.class.isAssignableFrom(clazz));
            Extension extension = (Extension)clazz.newInstance();
            XMLMapper xmlMapper = XMLMapper.Factory.create();
            TestParser testParser = new TestParser(SubsystemTestDelegate.this.mainSubsystemName, SubsystemTestDelegate.this.extensionParsingRegistry);
            ExtensionRegistry extensionParsingRegistry = new ExtensionRegistry(this.additionalInit.getProcessType(), new RunningModeControl(this.additionalInit.getExtensionRegistryRunningMode()));
            xmlMapper.registerRootElement(new QName("urn.org.jboss.test:1.0", "test"), (XMLElementReader)testParser);
            extension.initializeParsers(extensionParsingRegistry.getExtensionParsingContext("Test", xmlMapper));
            return KernelServicesImpl.create(SubsystemTestDelegate.this.mainSubsystemName, this.additionalInit, SubsystemTestDelegate.this.cloneExtensionRegistry(this.additionalInit), bootOperations, testParser, extension, this.modelVersion, false, this.persistXml);
        }

        @Override
        public LegacyKernelServicesInitializer dontPersistXml() {
            this.persistXml = false;
            return this;
        }
    }

    private class KernelServicesBuilderImpl
    implements KernelServicesBuilder,
    ModelTestBootOperationsBuilder.BootOperationParser {
        private final ModelTestBootOperationsBuilder bootOperationBuilder;
        private final AdditionalInitialization additionalInit;
        private Map<ModelVersion, LegacyKernelServiceInitializerImpl> legacyControllerInitializers = new HashMap<ModelVersion, LegacyKernelServiceInitializerImpl>();

        public KernelServicesBuilderImpl(AdditionalInitialization additionalInit) {
            this.additionalInit = additionalInit == null ? new AdditionalInitialization() : additionalInit;
            this.bootOperationBuilder = new ModelTestBootOperationsBuilder(SubsystemTestDelegate.this.testClass, (ModelTestBootOperationsBuilder.BootOperationParser)this);
        }

        @Override
        public KernelServicesBuilder setSubsystemXmlResource(String resource) throws IOException, XMLStreamException {
            this.bootOperationBuilder.setXmlResource(resource);
            return this;
        }

        @Override
        public KernelServicesBuilder setSubsystemXml(String subsystemXml) throws XMLStreamException {
            this.bootOperationBuilder.setXml(subsystemXml);
            return this;
        }

        @Override
        public KernelServicesBuilder setBootOperations(List<ModelNode> bootOperations) {
            this.bootOperationBuilder.setBootOperations(bootOperations);
            return this;
        }

        @Override
        public KernelServicesBuilder setBootOperations(ModelNode ... bootOperations) {
            this.bootOperationBuilder.setBootOperations(Arrays.asList(bootOperations));
            return this;
        }

        @Override
        public LegacyKernelServicesInitializer createLegacyKernelServicesBuilder(AdditionalInitialization additionalInit, ModelVersion modelVersion) {
            this.bootOperationBuilder.validateNotAlreadyBuilt();
            if (this.legacyControllerInitializers.containsKey(modelVersion)) {
                throw new IllegalArgumentException("There is already a legacy controller for " + modelVersion);
            }
            if (additionalInit != null && additionalInit.getRunningMode() != RunningMode.ADMIN_ONLY) {
                throw new IllegalArgumentException("The additional initialization must have a running mode of ADMIN_ONLY, it was " + additionalInit.getRunningMode());
            }
            LegacyKernelServiceInitializerImpl initializer = new LegacyKernelServiceInitializerImpl(additionalInit, modelVersion);
            this.legacyControllerInitializers.put(modelVersion, initializer);
            return initializer;
        }

        @Override
        public KernelServices build() throws Exception {
            this.bootOperationBuilder.validateNotAlreadyBuilt();
            List bootOperations = this.bootOperationBuilder.build();
            KernelServicesImpl kernelServices = KernelServicesImpl.create(SubsystemTestDelegate.this.mainSubsystemName, this.additionalInit, SubsystemTestDelegate.this.cloneExtensionRegistry(this.additionalInit), bootOperations, SubsystemTestDelegate.this.testParser, SubsystemTestDelegate.this.mainExtension, null, this.legacyControllerInitializers.size() > 0, true);
            SubsystemTestDelegate.this.kernelServices.add(kernelServices);
            SubsystemTestDelegate.this.validateDescriptionProviders(this.additionalInit, kernelServices);
            ImmutableManagementResourceRegistration subsystemReg = kernelServices.getRootRegistration().getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)SubsystemTestDelegate.this.mainSubsystemName)}));
            ModelTestUtils.validateModelDescriptions((PathAddress)PathAddress.EMPTY_ADDRESS, (ImmutableManagementResourceRegistration)subsystemReg);
            for (Map.Entry<ModelVersion, LegacyKernelServiceInitializerImpl> entry : this.legacyControllerInitializers.entrySet()) {
                LegacyKernelServiceInitializerImpl legacyInitializer = entry.getValue();
                ArrayList<ModelNode> transformedBootOperations = new ArrayList<ModelNode>();
                for (ModelNode op : bootOperations) {
                    OperationTransformer.TransformedOperation transformedOp = kernelServices.transformOperation(entry.getKey(), op);
                    if (transformedOp.getTransformedOperation() == null || transformedOp.rejectOperation(SUCCESS)) continue;
                    transformedBootOperations.add(transformedOp.getTransformedOperation());
                }
                KernelServicesImpl legacyServices = legacyInitializer.install(transformedBootOperations);
                kernelServices.addLegacyKernelService(entry.getKey(), legacyServices);
            }
            return kernelServices;
        }

        public List<ModelNode> parse(String subsystemXml) throws XMLStreamException {
            return SubsystemTestDelegate.this.parse(this.additionalInit, subsystemXml);
        }

        @Override
        public List<ModelNode> parseXml(String xml) throws Exception {
            ModelTestBootOperationsBuilder builder = new ModelTestBootOperationsBuilder(SubsystemTestDelegate.this.testClass, (ModelTestBootOperationsBuilder.BootOperationParser)this);
            builder.setXml(xml);
            return builder.build();
        }

        @Override
        public List<ModelNode> parseXmlResource(String xmlResource) throws Exception {
            ModelTestBootOperationsBuilder builder = new ModelTestBootOperationsBuilder(SubsystemTestDelegate.this.testClass, (ModelTestBootOperationsBuilder.BootOperationParser)this);
            builder.setXmlResource(xmlResource);
            return builder.build();
        }
    }
}

