/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.management.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class CLIOpResult {
    private boolean isOutcomeSuccess;
    private Object result;
    private Object serverGroups;

    public CLIOpResult() {
    }

    public CLIOpResult(ModelNode node) {
        Map<String, Object> map = this.toMap(node);
        this.isOutcomeSuccess = "success".equals(map.get("outcome"));
        this.result = map.get("result");
        this.serverGroups = map.get("server-groups");
    }

    protected Map<String, Object> toMap(ModelNode node) {
        Set keys = node.keys();
        HashMap<String, Object> map = new HashMap<String, Object>(keys.size());
        for (String key : keys) {
            map.put(key, this.toObject(node.get(key)));
        }
        return map;
    }

    protected List<Object> toList(ModelNode node) {
        List nodeList = node.asList();
        ArrayList<Object> list = new ArrayList<Object>(nodeList.size());
        for (ModelNode item : nodeList) {
            list.add(this.toObject(item));
        }
        return list;
    }

    protected Object toObject(ModelNode node) {
        ModelType type = node.getType();
        if (type.equals((Object)ModelType.LIST)) {
            return this.toList(node);
        }
        if (type.equals((Object)ModelType.OBJECT)) {
            return this.toMap(node);
        }
        if (type.equals((Object)ModelType.PROPERTY)) {
            Property prop = node.asProperty();
            return Collections.singletonMap(prop.getName(), this.toObject(prop.getValue()));
        }
        return node.asString();
    }

    public boolean isIsOutcomeSuccess() {
        return this.isOutcomeSuccess;
    }

    public void setIsOutcomeSuccess(boolean isOutcomeSuccess) {
        this.isOutcomeSuccess = isOutcomeSuccess;
    }

    public Object getResult() {
        return this.result;
    }

    public Map<String, Object> getResultAsMap() {
        return (Map)(this.result instanceof Map ? this.result : null);
    }

    public Object getNamedResult(String key) {
        Map<String, Object> map = this.getResultAsMap();
        return map != null ? map.get(key) : null;
    }

    public Map<String, Object> getNamedResultAsMap(String key) {
        Object value = this.getNamedResult(key);
        return (Map)(value instanceof Map ? value : null);
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public Object getServerGroups() {
        return this.serverGroups;
    }

    public void setServerGroups(Object serverGroups) {
        this.serverGroups = serverGroups;
    }
}

