/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.management;

import java.util.HashSet;
import java.util.List;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.test.integration.management.Connector;
import org.jboss.as.test.integration.management.base.AbstractMgmtTestBase;
import org.jboss.as.test.integration.management.util.ModelUtil;
import org.jboss.as.test.integration.management.util.WebUtil;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;

public class ServerManager
extends AbstractMgmtTestBase {
    private final ManagementClient managementClient;

    public ServerManager(ManagementClient managementClient) {
        this.managementClient = managementClient;
    }

    @Override
    protected ModelControllerClient getModelControllerClient() {
        return this.managementClient.getControllerClient();
    }

    public void addConnector(Connector conn, int port, String keyPEMFile, String certPEMFile, String keyStoreFile, String password) throws Exception {
        ModelNode op = this.getAddSocketBindingOp(conn, port);
        this.executeOperation(op);
        op = this.getAddConnectorOp(conn, keyStoreFile, password);
        this.executeOperation(op);
        Assert.assertTrue((boolean)this.getConnectorList().contains("test-" + conn.getName() + "-connector"));
    }

    private ModelNode getAddSocketBindingOp(Connector conn, int port) {
        ModelNode op = ModelUtil.createOpNode("socket-binding-group=standard-sockets/socket-binding=test-" + conn.getName(), "add");
        op.get("port").set(port);
        return op;
    }

    private ModelNode getAddConnectorOp(Connector conn, String keyStoreFile, String password) {
        ModelNode composite = Util.getEmptyOperation((String)"composite", (ModelNode)new ModelNode());
        ModelNode steps = composite.get("steps");
        ModelNode op = ModelUtil.createOpNode("subsystem=web/connector=test-" + conn.getName() + "-connector", "add");
        op.get("socket-binding").set("test-" + conn.getName());
        op.get("scheme").set(conn.getScheme());
        op.get("protocol").set(conn.getProtocol());
        op.get("secure").set(conn.isSecure());
        op.get("enabled").set(true);
        steps.add(op);
        if (conn.isSecure()) {
            ModelNode ssl = ModelUtil.createOpNode("subsystem=web/connector=test-" + conn.getName() + "-connector/ssl=configuration", "add");
            ssl.get("certificate-key-file").set(keyStoreFile);
            ssl.get("password").set(password);
            steps.add(ssl);
        }
        return composite;
    }

    public void removeConnector(Connector conn, String checkURL) throws Exception {
        ModelNode op = this.getRemoveConnectorOp(conn);
        this.executeOperation(op);
        Thread.sleep(5000L);
        if (checkURL != null) {
            Assert.assertFalse((String)"Connector not removed.", (boolean)WebUtil.testHttpURL(checkURL));
        }
        op = this.getRemoveSocketBindingOp(conn);
        this.executeOperation(op);
    }

    private ModelNode getRemoveSocketBindingOp(Connector conn) {
        ModelNode op = ModelUtil.createOpNode("socket-binding-group=standard-sockets/socket-binding=test-" + conn.getName(), "remove");
        return op;
    }

    private ModelNode getRemoveConnectorOp(Connector conn) {
        ModelNode op = ModelUtil.createOpNode("subsystem=web/connector=test-" + conn.getName() + "-connector", "remove");
        return op;
    }

    public HashSet<String> getConnectorList() throws Exception {
        ModelNode op = ModelUtil.createOpNode("subsystem=web", "read-children-names");
        op.get("child-type").set("connector");
        ModelNode result = this.executeOperation(op);
        List connectors = result.asList();
        HashSet<String> connNames = new HashSet<String>();
        for (ModelNode n : connectors) {
            connNames.add(n.asString());
        }
        return connNames;
    }
}

