/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import javax.naming.Referenceable;
import javax.xml.ws.WebServiceRef;
import javax.xml.ws.WebServiceRefs;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ClassConfigurator;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEApplicationDescription;
import org.jboss.as.ee.component.EEModuleClassConfiguration;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.FieldInjectionTarget;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.InjectionTarget;
import org.jboss.as.ee.component.LookupInjectionSource;
import org.jboss.as.ee.component.MethodInjectionTarget;
import org.jboss.as.ee.component.ResourceInjectionConfiguration;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.webservices.util.VirtualFileAdaptor;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.modules.Module;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.value.Value;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.jboss.wsf.spi.serviceref.ServiceRefHandler;
import org.jboss.wsf.spi.serviceref.ServiceRefHandlerFactory;
import org.jboss.wsf.stack.cxf.client.serviceref.CXFServiceObjectFactoryJAXWS;

public class WebServiceRefAnnotationParsingProcessor
implements DeploymentUnitProcessor {
    private static final DotName WEB_SERVICE_REF_ANNOTATION_NAME = DotName.createSimple((String)WebServiceRef.class.getName());
    private static final DotName WEB_SERVICE_REFS_ANNOTATION_NAME = DotName.createSimple((String)WebServiceRefs.class.getName());

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_MODULE_DESCRIPTION);
        EEApplicationClasses applicationClasses = (EEApplicationClasses)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        List resourceAnnotations = index.getAnnotations(WEB_SERVICE_REF_ANNOTATION_NAME);
        for (AnnotationInstance annotation : resourceAnnotations) {
            AnnotationTarget annotationTarget = annotation.target();
            WebServiceRefWrapper annotationWrapper = new WebServiceRefWrapper(annotation);
            if (annotationTarget instanceof FieldInfo) {
                this.processFieldRef(deploymentUnit, module, eeModuleDescription, annotationWrapper, (FieldInfo)annotationTarget, applicationClasses);
                continue;
            }
            if (annotationTarget instanceof MethodInfo) {
                this.processMethodRef(deploymentUnit, module, eeModuleDescription, annotationWrapper, (MethodInfo)annotationTarget, applicationClasses);
                continue;
            }
            if (!(annotationTarget instanceof ClassInfo)) continue;
            this.processClassRef(deploymentUnit, module, eeModuleDescription, annotationWrapper, (ClassInfo)annotationTarget, applicationClasses);
        }
        List resourcesAnnotations = index.getAnnotations(WEB_SERVICE_REFS_ANNOTATION_NAME);
        for (AnnotationInstance outerAnnotation : resourcesAnnotations) {
            AnnotationInstance[] values;
            AnnotationTarget annotationTarget = outerAnnotation.target();
            if (!(annotationTarget instanceof ClassInfo)) continue;
            for (AnnotationInstance annotation : values = outerAnnotation.value("value").asNestedArray()) {
                this.processClassRef(deploymentUnit, module, eeModuleDescription, new WebServiceRefWrapper(annotation), (ClassInfo)annotationTarget, applicationClasses);
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void processFieldRef(DeploymentUnit deploymentUnit, Module module, EEModuleDescription eeModuleDescription, WebServiceRefWrapper annotation, FieldInfo fieldInfo, EEApplicationClasses applicationClasses) {
        String fieldName = fieldInfo.name();
        String injectionType = this.isEmpty(annotation.type()) || annotation.type().equals(Object.class.getName()) ? fieldInfo.type().name().toString() : annotation.type();
        FieldInjectionTarget targetDescription = new FieldInjectionTarget(fieldInfo.declaringClass().name().toString(), fieldName, injectionType);
        String localContextName = this.isEmpty(annotation.name()) ? fieldInfo.declaringClass().name().toString() + "/" + fieldInfo.name() : annotation.name();
        this.processRef(deploymentUnit, module, eeModuleDescription, annotation.name(), targetDescription.getClassName(), annotation.value(), annotation.wsdlLocation(), fieldInfo.declaringClass(), (InjectionTarget)targetDescription, localContextName, applicationClasses);
    }

    private void processMethodRef(DeploymentUnit deploymentUnit, Module module, EEModuleDescription eeModuleDescription, WebServiceRefWrapper annotation, MethodInfo methodInfo, EEApplicationClasses applicationClasses) {
        String methodName = methodInfo.name();
        if (!methodName.startsWith("set") || methodInfo.args().length != 1) {
            throw new IllegalArgumentException("@WebServiceRef injection target is invalid.  Only setter methods are allowed: " + methodInfo);
        }
        String injectionType = this.isEmpty(annotation.type()) || annotation.type().equals(Object.class.getName()) ? methodInfo.args()[0].name().toString() : annotation.type();
        MethodInjectionTarget targetDescription = new MethodInjectionTarget(methodInfo.declaringClass().name().toString(), methodName, injectionType);
        String localContextName = this.isEmpty(annotation.name()) ? methodInfo.declaringClass().name().toString() + "/" + methodName.substring(3, 4).toLowerCase() + methodName.substring(4) : annotation.name();
        this.processRef(deploymentUnit, module, eeModuleDescription, annotation.name(), targetDescription.getClassName(), annotation.value(), annotation.wsdlLocation(), methodInfo.declaringClass(), (InjectionTarget)targetDescription, localContextName, applicationClasses);
    }

    private void processClassRef(DeploymentUnit deploymentUnit, Module module, EEModuleDescription eeModuleDescription, WebServiceRefWrapper annotation, ClassInfo classInfo, EEApplicationClasses applicationClasses) throws DeploymentUnitProcessingException {
        if (this.isEmpty(annotation.name())) {
            throw new DeploymentUnitProcessingException("@WebServiceRef attribute 'name' is required fo class level annotations.");
        }
        if (this.isEmpty(annotation.type())) {
            throw new DeploymentUnitProcessingException("@WebServiceRef attribute 'type' is required fo class level annotations.");
        }
        this.processRef(deploymentUnit, module, eeModuleDescription, annotation.name(), annotation.type(), annotation.value(), annotation.wsdlLocation(), classInfo, null, annotation.name(), applicationClasses);
    }

    private void processRef(DeploymentUnit deploymentUnit, Module module, EEModuleDescription eeModuleDescription, String name, String type, String value, String wsdlLocation, ClassInfo classInfo, InjectionTarget targetDescription, String localContextName, EEApplicationClasses applicationClasses) {
        EEModuleClassDescription classDescription = applicationClasses.getOrAddClassByName(classInfo.name().toString());
        final ResourceInjectionConfiguration injectionConfiguration = targetDescription != null ? new ResourceInjectionConfiguration(targetDescription, (InjectionSource)new LookupInjectionSource(localContextName)) : null;
        WebServiceRefValueSource valueSource = new WebServiceRefValueSource(module, this.getServiceReference(deploymentUnit, name, type, value, wsdlLocation));
        final BindingConfiguration bindingConfiguration = new BindingConfiguration(localContextName, (InjectionSource)valueSource);
        classDescription.getConfigurators().add(new ClassConfigurator(){

            public void configure(DeploymentPhaseContext context, EEModuleClassDescription description, EEModuleClassConfiguration configuration) throws DeploymentUnitProcessingException {
                configuration.getBindingConfigurations().add(bindingConfiguration);
                if (injectionConfiguration != null) {
                    configuration.getInjectionConfigurations().add(injectionConfiguration);
                }
            }
        });
    }

    private UnifiedServiceRefMetaData getServiceReference(DeploymentUnit deploymentUnit, String name, String type, String value, String wsdlLocation) {
        UnifiedServiceRefMetaData reference = new UnifiedServiceRefMetaData(this.getUnifiedVirtualFile(deploymentUnit));
        reference.setServiceRefName(name);
        if (wsdlLocation != null && wsdlLocation.length() > 0) {
            reference.setWsdlFile(wsdlLocation);
        }
        reference.setServiceRefType(type);
        reference.setServiceInterface(value);
        boolean isJAXRPC = reference.getMappingFile() != null || "javax.xml.rpc.Service".equals(reference.getServiceInterface());
        reference.setType(isJAXRPC ? ServiceRefHandler.Type.JAXRPC : ServiceRefHandler.Type.JAXWS);
        return reference;
    }

    private UnifiedVirtualFile getUnifiedVirtualFile(DeploymentUnit deploymentUnit) {
        ResourceRoot resourceRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        if (resourceRoot == null) {
            throw new IllegalStateException("Resource root not found for deployment " + deploymentUnit);
        }
        return new VirtualFileAdaptor(resourceRoot.getRoot());
    }

    private boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    private class WebServiceRefWrapper {
        private final String type;
        private final String name;
        private final String value;
        private final String wsdlLocation;

        private WebServiceRefWrapper(AnnotationInstance annotation) {
            this.name = this.stringValueOrNull(annotation, "name");
            this.type = this.classValueOrNull(annotation, "type");
            this.value = this.classValueOrNull(annotation, "value");
            this.wsdlLocation = this.stringValueOrNull(annotation, "wsdlLocation");
        }

        private String name() {
            return this.name;
        }

        private String type() {
            return this.type;
        }

        private String value() {
            return this.value;
        }

        private String wsdlLocation() {
            return this.wsdlLocation;
        }

        private String stringValueOrNull(AnnotationInstance annotation, String attribute) {
            AnnotationValue value = annotation.value(attribute);
            return value != null ? value.asString() : null;
        }

        private String classValueOrNull(AnnotationInstance annotation, String attribute) {
            AnnotationValue value = annotation.value(attribute);
            return value != null ? value.asClass().name().toString() : null;
        }
    }

    private static class WebServiceRefValueSource
    extends InjectionSource
    implements Value<Object> {
        private final Module module;
        private final UnifiedServiceRefMetaData serviceRef;

        private WebServiceRefValueSource(Module module, UnifiedServiceRefMetaData serviceRef) {
            this.module = module;
            this.serviceRef = serviceRef;
        }

        public void getResourceValue(InjectionSource.ResolutionContext resolutionContext, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) throws DeploymentUnitProcessingException {
            DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
            EEApplicationDescription applicationComponentDescription = (EEApplicationDescription)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_APPLICATION_DESCRIPTION);
            if (applicationComponentDescription == null) {
                return;
            }
            ValueManagedReferenceFactory factory = new ValueManagedReferenceFactory((Value)this);
            serviceBuilder.addInjection(injector, (Object)factory);
        }

        public Object getValue() throws IllegalStateException, IllegalArgumentException {
            ClassLoader tccl = ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader();
            ClassLoader classLoader = new ClassLoader(((Object)((Object)this)).getClass().getClassLoader()){

                @Override
                public Class<?> loadClass(String className) throws ClassNotFoundException {
                    try {
                        return super.loadClass(className);
                    }
                    catch (ClassNotFoundException cnfe) {
                        return WebServiceRefValueSource.this.module.getClassLoader().loadClass(className);
                    }
                }

                @Override
                public Enumeration<URL> getResources(String name) throws IOException {
                    final Enumeration<URL> superResources = super.getResources(name);
                    final Enumeration duModuleCLResources = WebServiceRefValueSource.this.module.getClassLoader().getResources(name);
                    if (superResources == null || !superResources.hasMoreElements()) {
                        return duModuleCLResources;
                    }
                    if (duModuleCLResources == null || !duModuleCLResources.hasMoreElements()) {
                        return superResources;
                    }
                    return new Enumeration<URL>(){

                        @Override
                        public boolean hasMoreElements() {
                            return superResources.hasMoreElements() || duModuleCLResources.hasMoreElements();
                        }

                        @Override
                        public URL nextElement() {
                            if (superResources.hasMoreElements()) {
                                return (URL)superResources.nextElement();
                            }
                            return (URL)duModuleCLResources.nextElement();
                        }
                    };
                }
            };
            Thread.currentThread().setContextClassLoader(classLoader);
            try {
                Object object = new CXFServiceObjectFactoryJAXWS().getObjectInstance((Object)this.getReferenceable(), null, null, null);
                return object;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(tccl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Referenceable getReferenceable() {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
                ServiceRefHandler serviceRefHandler = ((ServiceRefHandlerFactory)spiProvider.getSPI(ServiceRefHandlerFactory.class)).getServiceRefHandler();
                Referenceable referenceable = serviceRefHandler.createReferenceable(this.serviceRef);
                return referenceable;
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
    }
}

