/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers.deployment;

import java.util.List;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.webservices.deployers.deployment.AbstractDeploymentModelBuilder;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.ServletMetaData;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.metadata.jms.JMSEndpointMetaData;
import org.jboss.wsf.spi.metadata.jms.JMSEndpointsMetaData;

final class DeploymentModelBuilderJAXWS_JSE
extends AbstractDeploymentModelBuilder {
    DeploymentModelBuilderJAXWS_JSE() {
    }

    @Override
    protected void build(Deployment dep, DeploymentUnit unit) {
        JMSEndpointsMetaData jmsEndpointsMD;
        this.log.debug((Object)"Creating JAXWS JSE endpoints meta data model");
        JBossWebMetaData webMetaData = ASHelper.getJBossWebMetaData(unit);
        if (webMetaData != null) {
            dep.addAttachment(JBossWebMetaData.class, (Object)webMetaData);
            List<ServletMetaData> servlets = ASHelper.getJaxwsServlets(unit);
            for (ServletMetaData servlet : servlets) {
                String servletName = servlet.getName();
                this.log.debug((Object)("JSE name: " + servletName));
                String servletClass = ASHelper.getEndpointName(servlet);
                this.log.debug((Object)("JSE class: " + servletClass));
                this.newHttpEndpoint(servletClass, servletName, dep);
            }
        }
        if ((jmsEndpointsMD = ASHelper.getOptionalAttachment(unit, WSAttachmentKeys.JMS_ENDPOINT_METADATA_KEY)) != null) {
            dep.addAttachment(JMSEndpointsMetaData.class, (Object)jmsEndpointsMD);
            for (JMSEndpointMetaData endpoint : jmsEndpointsMD.getEndpointsMetaData()) {
                if (endpoint.getName() == null) {
                    endpoint.setName(endpoint.getImplementor());
                }
                this.newJMSEndpoint(endpoint.getImplementor(), endpoint.getName(), endpoint.getSoapAddress(), dep);
            }
        }
    }
}

