/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.service;

import javax.management.MBeanServer;
import org.jboss.as.webservices.util.WSServices;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.ws.common.management.DefaultEndpointRegistry;
import org.jboss.ws.common.management.ManagedEndpointRegistry;
import org.jboss.wsf.spi.management.EndpointRegistry;

public final class EndpointRegistryService
implements Service<EndpointRegistry> {
    private static final Logger log = Logger.getLogger(EndpointRegistryService.class);
    private static final ServiceName MBEAN_SERVER_NAME = ServiceName.JBOSS.append(new String[]{"mbean", "server"});
    private static final EndpointRegistryService INSTANCE = new EndpointRegistryService();
    private volatile EndpointRegistry registry;
    private final InjectedValue<MBeanServer> injectedMBeanServer = new InjectedValue();

    private EndpointRegistryService() {
    }

    public EndpointRegistry getValue() {
        return this.registry;
    }

    public void start(StartContext context) throws StartException {
        log.tracef("Starting %s", (Object)EndpointRegistryService.class.getName());
        if (this.injectedMBeanServer.getValue() != null) {
            ManagedEndpointRegistry managedEndpointRegistry = new ManagedEndpointRegistry();
            managedEndpointRegistry.setMbeanServer((MBeanServer)this.injectedMBeanServer.getValue());
            this.registry = managedEndpointRegistry;
        } else {
            this.registry = new DefaultEndpointRegistry();
        }
    }

    public void stop(StopContext context) {
        log.tracef("Stopping %s", (Object)EndpointRegistryService.class.getName());
    }

    private InjectedValue<MBeanServer> getMBeanServerInjector() {
        return this.injectedMBeanServer;
    }

    public static ServiceController<?> install(ServiceTarget serviceTarget, ServiceListener<Object> ... listeners) {
        ServiceBuilder builder = serviceTarget.addService(WSServices.REGISTRY_SERVICE, (Service)INSTANCE);
        builder.addDependency(ServiceBuilder.DependencyType.REQUIRED, MBEAN_SERVER_NAME, MBeanServer.class, INSTANCE.getMBeanServerInjector());
        builder.addListener(listeners);
        builder.setInitialMode(ServiceController.Mode.ACTIVE);
        return builder.install();
    }
}

