/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2011, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.as.webservices.dmr;

import static org.jboss.as.controller.descriptions.ModelDescriptionConstants.ADD;
import static org.jboss.as.controller.descriptions.ModelDescriptionConstants.OP;
import static org.jboss.as.controller.descriptions.ModelDescriptionConstants.OP_ADDR;
import static org.jboss.as.webservices.dmr.Constants.MODIFY_WSDL_ADDRESS;
import static org.jboss.as.webservices.dmr.Constants.WSDL_HOST;
import static org.jboss.as.webservices.dmr.Constants.WSDL_PORT;
import static org.jboss.as.webservices.dmr.Constants.WSDL_SECURE_PORT;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;

/**
 * @author Emanuel Muckenhuber
 */
final class WSSubsystemDescribe implements OperationStepHandler {

    static final WSSubsystemDescribe INSTANCE = new WSSubsystemDescribe();

    private WSSubsystemDescribe() {
        // forbidden inheritance
    }

    /** {@inheritDoc} */
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final PathAddress rootAddress = PathAddress.pathAddress(PathAddress.pathAddress(operation.require(OP_ADDR))
                .getLastElement());
        final ModelNode subModel = context.readModel(PathAddress.EMPTY_ADDRESS);

        final ModelNode subsystemAdd = new ModelNode();
        subsystemAdd.get(OP).set(ADD);
        subsystemAdd.get(OP_ADDR).set(rootAddress.toModelNode());

        if (subModel.hasDefined(MODIFY_WSDL_ADDRESS)) {
            subsystemAdd.get(MODIFY_WSDL_ADDRESS).set(subModel.get(MODIFY_WSDL_ADDRESS));
        }

        if (subModel.hasDefined(WSDL_HOST)) {
            subsystemAdd.get(WSDL_HOST).set(subModel.get(WSDL_HOST));
        }

        if (subModel.hasDefined(WSDL_PORT)) {
            subsystemAdd.get(WSDL_PORT).set(subModel.get(WSDL_PORT));
        }

        if (subModel.hasDefined(WSDL_SECURE_PORT)) {
            subsystemAdd.get(WSDL_SECURE_PORT).set(subModel.get(WSDL_SECURE_PORT));
        }

        context.getResult().add(subsystemAdd);
        context.completeStep();
    }
}
