/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.parser.ee;

import java.util.HashSet;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.annotation.javaee.Descriptions;
import org.jboss.metadata.javaee.spec.DescriptionsImpl;
import org.jboss.metadata.javaee.spec.SecurityRoleMetaData;
import org.jboss.metadata.parser.ee.Attribute;
import org.jboss.metadata.parser.ee.DescriptionsMetaDataParser;
import org.jboss.metadata.parser.ee.Element;
import org.jboss.metadata.parser.util.MetaDataElementParser;

public class SecurityRoleMetaDataParser
extends MetaDataElementParser {
    public static SecurityRoleMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        SecurityRoleMetaData securityRole = new SecurityRoleMetaData();
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    securityRole.setId(value);
                    continue block7;
                }
                default: {
                    throw SecurityRoleMetaDataParser.unexpectedAttribute(reader, i);
                }
            }
        }
        DescriptionsImpl descriptions = new DescriptionsImpl();
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            if (DescriptionsMetaDataParser.parse(reader, descriptions)) {
                if (securityRole.getDescriptions() != null) continue;
                securityRole.setDescriptions((Descriptions)descriptions);
                continue;
            }
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ROLE_NAME: {
                    securityRole.setRoleName(reader.getElementText());
                    continue block8;
                }
                case PRINCIPAL_NAME: {
                    HashSet<String> principalNames = securityRole.getPrincipals();
                    if (principalNames == null) {
                        principalNames = new HashSet<String>();
                        securityRole.setPrincipals(principalNames);
                    }
                    principalNames.add(reader.getElementText());
                    continue block8;
                }
            }
            throw SecurityRoleMetaDataParser.unexpectedElement(reader);
        }
        return securityRole;
    }
}

