/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.parser.jbossweb;

import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.parser.jbossweb.Attribute;
import org.jboss.metadata.parser.jbossweb.ContainerListenerMetaDataParser;
import org.jboss.metadata.parser.jbossweb.Element;
import org.jboss.metadata.parser.jbossweb.JBossAnnotationMetaDataParser;
import org.jboss.metadata.parser.jbossweb.Location;
import org.jboss.metadata.parser.jbossweb.ValveMetaDataParser;
import org.jboss.metadata.parser.jbossweb.Version;
import org.jboss.metadata.parser.servlet.SessionConfigMetaDataParser;
import org.jboss.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.web.jboss.ContainerListenerMetaData;
import org.jboss.metadata.web.jboss.JBoss4xDTDWebMetaData;
import org.jboss.metadata.web.jboss.JBoss50DTDWebMetaData;
import org.jboss.metadata.web.jboss.JBoss50WebMetaData;
import org.jboss.metadata.web.jboss.JBoss60WebMetaData;
import org.jboss.metadata.web.jboss.JBossAnnotationsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.jboss.ValveMetaData;

public class JBossWebMetaDataParser
extends MetaDataElementParser {
    public static JBossWebMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        reader.require(7, null, null);
        Version version = null;
        while (reader.hasNext() && reader.next() != 1) {
            if (reader.getEventType() != 11) continue;
            String dtdLocation = JBossWebMetaDataParser.readDTDLocation(reader);
            if (dtdLocation != null) {
                version = Location.getVersion(dtdLocation);
            }
            if (version != null) continue;
            version = Version.JBOSS_WEB_5_0;
        }
        String schemaLocation = JBossWebMetaDataParser.readSchemaLocation(reader);
        if (schemaLocation != null) {
            version = Location.getVersion(schemaLocation);
        }
        if (version == null) {
            version = Version.JBOSS_WEB_6_0;
        }
        JBoss4xDTDWebMetaData wmd = null;
        switch (version) {
            case JBOSS_WEB_3_0: {
                wmd = new JBoss4xDTDWebMetaData();
                break;
            }
            case JBOSS_WEB_3_2: {
                wmd = new JBoss4xDTDWebMetaData();
                break;
            }
            case JBOSS_WEB_4_0: {
                wmd = new JBoss4xDTDWebMetaData();
                break;
            }
            case JBOSS_WEB_4_2: {
                wmd = new JBoss4xDTDWebMetaData();
                break;
            }
            case JBOSS_WEB_5_0: {
                wmd = new JBoss50DTDWebMetaData();
                break;
            }
            case JBOSS_WEB_5_1: {
                wmd = new JBoss50WebMetaData();
                break;
            }
            case JBOSS_WEB_6_0: {
                wmd = new JBoss60WebMetaData();
            }
        }
        int count = reader.getAttributeCount();
        block22: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case VERSION: {
                    wmd.setVersion(value);
                    continue block22;
                }
                default: {
                    throw JBossWebMetaDataParser.unexpectedAttribute(reader, i);
                }
            }
        }
        block23: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CONTEXT_ROOT: {
                    wmd.setContextRoot(reader.getElementText());
                    continue block23;
                }
                case VIRTUAL_HOST: {
                    ArrayList<String> virtualHosts = wmd.getVirtualHosts();
                    if (virtualHosts == null) {
                        virtualHosts = new ArrayList<String>();
                        wmd.setVirtualHosts(virtualHosts);
                        virtualHosts.add(reader.getElementText());
                        continue block23;
                    }
                    throw JBossWebMetaDataParser.duplicateNamedElement(reader, Element.VIRTUAL_HOST.toString());
                }
                case ANNOTATION: {
                    JBossAnnotationsMetaData annotations = wmd.getAnnotations();
                    if (annotations == null) {
                        annotations = new JBossAnnotationsMetaData();
                        wmd.setAnnotations(annotations);
                    }
                    annotations.add((MappableMetaData)JBossAnnotationMetaDataParser.parse(reader));
                    continue block23;
                }
                case LISTENER: {
                    ArrayList<ContainerListenerMetaData> listeners = wmd.getContainerListeners();
                    if (listeners == null) {
                        listeners = new ArrayList<ContainerListenerMetaData>();
                        wmd.setContainerListeners(listeners);
                    }
                    listeners.add(ContainerListenerMetaDataParser.parse(reader));
                    continue block23;
                }
                case SESSION_CONFIG: {
                    wmd.setSessionConfig(SessionConfigMetaDataParser.parse(reader));
                    continue block23;
                }
                case VALVE: {
                    ArrayList<ValveMetaData> valves = wmd.getValves();
                    if (valves == null) {
                        valves = new ArrayList<ValveMetaData>();
                        wmd.setValves(valves);
                    }
                    valves.add(ValveMetaDataParser.parse(reader));
                    continue block23;
                }
                case OVERLAY: {
                    ArrayList<String> overlays = wmd.getOverlays();
                    if (overlays == null) {
                        overlays = new ArrayList<String>();
                        wmd.setOverlays(overlays);
                    }
                    overlays.add(reader.getElementText());
                    continue block23;
                }
            }
            throw JBossWebMetaDataParser.unexpectedElement(reader);
        }
        return wmd;
    }
}

