/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.parser.jsp;

import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.parser.ee.DescriptionGroupMetaDataParser;
import org.jboss.metadata.parser.jsp.Attribute;
import org.jboss.metadata.parser.jsp.AttributeMetaDataParser;
import org.jboss.metadata.parser.jsp.Element;
import org.jboss.metadata.parser.jsp.TldExtensionMetaDataParser;
import org.jboss.metadata.parser.jsp.VariableMetaDataParser;
import org.jboss.metadata.parser.jsp.Version;
import org.jboss.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.web.spec.AttributeMetaData;
import org.jboss.metadata.web.spec.BodyContentType;
import org.jboss.metadata.web.spec.Tag11MetaData;
import org.jboss.metadata.web.spec.Tag12MetaData;
import org.jboss.metadata.web.spec.TagMetaData;
import org.jboss.metadata.web.spec.TldExtensionMetaData;
import org.jboss.metadata.web.spec.VariableMetaData;

public class TagMetaDataParser
extends MetaDataElementParser {
    public static TagMetaData parse(XMLStreamReader reader, Version version) throws XMLStreamException {
        Tag11MetaData tag = null;
        switch (version) {
            case TLD_1_1: {
                tag = new Tag11MetaData();
                break;
            }
            case TLD_1_2: {
                tag = new Tag12MetaData();
                break;
            }
            default: {
                tag = new TagMetaData();
            }
        }
        int count = reader.getAttributeCount();
        block24: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    tag.setId(value);
                    continue block24;
                }
                default: {
                    throw TagMetaDataParser.unexpectedAttribute(reader, i);
                }
            }
        }
        DescriptionGroupMetaData descriptionGroup = new DescriptionGroupMetaData();
        block25: while (reader.hasNext() && reader.nextTag() != 2) {
            if (DescriptionGroupMetaDataParser.parse(reader, descriptionGroup)) {
                if (tag.getDescriptionGroup() != null) continue;
                tag.setDescriptionGroup(descriptionGroup);
                continue;
            }
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case NAME: {
                    tag.setName(reader.getElementText());
                    continue block25;
                }
                case TAG_CLASS: {
                    tag.setTagClass(reader.getElementText());
                    continue block25;
                }
                case TAGCLASS: {
                    if (version == Version.TLD_1_1) {
                        tag.setTagClass(reader.getElementText());
                        continue block25;
                    }
                    throw TagMetaDataParser.unexpectedElement(reader);
                }
                case TEI_CLASS: {
                    tag.setTeiClass(reader.getElementText());
                    continue block25;
                }
                case TEICLASS: {
                    if (version == Version.TLD_1_1) {
                        tag.setTeiClass(reader.getElementText());
                        continue block25;
                    }
                    throw TagMetaDataParser.unexpectedElement(reader);
                }
                case BODY_CONTENT: {
                    tag.setBodyContent(BodyContentType.valueOf((String)reader.getElementText()));
                    continue block25;
                }
                case BODYCONTENT: {
                    if (version == Version.TLD_1_1) {
                        tag.setBodyContent(BodyContentType.valueOf((String)reader.getElementText()));
                        continue block25;
                    }
                    throw TagMetaDataParser.unexpectedElement(reader);
                }
                case INFO: {
                    if (version == Version.TLD_1_1) {
                        tag.setInfo(reader.getElementText());
                        continue block25;
                    }
                    throw TagMetaDataParser.unexpectedElement(reader);
                }
                case SMALL_ICON: {
                    if (version == Version.TLD_1_2) {
                        ((Tag12MetaData)tag).setSmallIcon(reader.getElementText());
                        continue block25;
                    }
                    throw TagMetaDataParser.unexpectedElement(reader);
                }
                case LARGE_ICON: {
                    if (version == Version.TLD_1_2) {
                        ((Tag12MetaData)tag).setLargeIcon(reader.getElementText());
                        continue block25;
                    }
                    throw TagMetaDataParser.unexpectedElement(reader);
                }
                case VARIABLE: {
                    ArrayList<VariableMetaData> variables = tag.getVariables();
                    if (variables == null) {
                        variables = new ArrayList<VariableMetaData>();
                        tag.setVariables(variables);
                    }
                    variables.add(VariableMetaDataParser.parse(reader));
                    continue block25;
                }
                case ATTRIBUTE: {
                    ArrayList<AttributeMetaData> attributes = tag.getAttributes();
                    if (attributes == null) {
                        attributes = new ArrayList<AttributeMetaData>();
                        tag.setAttributes(attributes);
                    }
                    attributes.add(AttributeMetaDataParser.parse(reader));
                    continue block25;
                }
                case DYNAMIC_ATTRIBUTES: {
                    tag.setDynamicAttributes(reader.getElementText());
                    continue block25;
                }
                case EXAMPLE: {
                    ArrayList<String> examples = tag.getExamples();
                    if (examples == null) {
                        examples = new ArrayList<String>();
                        tag.setExamples(examples);
                    }
                    examples.add(reader.getElementText());
                    continue block25;
                }
                case TAG_EXTENSION: {
                    ArrayList<TldExtensionMetaData> extensions = tag.getTagExtensions();
                    if (extensions == null) {
                        extensions = new ArrayList<TldExtensionMetaData>();
                        tag.setTagExtensions(extensions);
                    }
                    extensions.add(TldExtensionMetaDataParser.parse(reader));
                    continue block25;
                }
            }
            throw TagMetaDataParser.unexpectedElement(reader);
        }
        return tag;
    }
}

