/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.parser.servlet;

import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.parser.servlet.Attribute;
import org.jboss.metadata.parser.servlet.Element;
import org.jboss.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.web.spec.DispatcherType;
import org.jboss.metadata.web.spec.FilterMappingMetaData;

public class FilterMappingMetaDataParser
extends MetaDataElementParser {
    public static FilterMappingMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        FilterMappingMetaData filterMapping = new FilterMappingMetaData();
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    filterMapping.setId(value);
                    continue block9;
                }
                default: {
                    throw FilterMappingMetaDataParser.unexpectedAttribute(reader, i);
                }
            }
        }
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case FILTER_NAME: {
                    filterMapping.setFilterName(reader.getElementText());
                    continue block10;
                }
                case URL_PATTERN: {
                    ArrayList<String> urlPatterns = filterMapping.getUrlPatterns();
                    if (urlPatterns == null) {
                        urlPatterns = new ArrayList<String>();
                        filterMapping.setUrlPatterns(urlPatterns);
                    }
                    urlPatterns.add(reader.getElementText());
                    continue block10;
                }
                case SERVLET_NAME: {
                    ArrayList<String> servletNames = filterMapping.getServletNames();
                    if (servletNames == null) {
                        servletNames = new ArrayList<String>();
                        filterMapping.setServletNames(servletNames);
                    }
                    servletNames.add(reader.getElementText());
                    continue block10;
                }
                case DISPATCHER: {
                    ArrayList<DispatcherType> dispatchers = filterMapping.getDispatchers();
                    if (dispatchers == null) {
                        dispatchers = new ArrayList<DispatcherType>();
                        filterMapping.setDispatchers(dispatchers);
                    }
                    dispatchers.add(DispatcherType.valueOf((String)reader.getElementText()));
                    continue block10;
                }
            }
            throw FilterMappingMetaDataParser.unexpectedElement(reader);
        }
        return filterMapping;
    }
}

