/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.parser.servlet;

import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.parser.servlet.Attribute;
import org.jboss.metadata.parser.servlet.CookieConfigMetaDataParser;
import org.jboss.metadata.parser.servlet.Element;
import org.jboss.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.web.spec.SessionConfigMetaData;
import org.jboss.metadata.web.spec.SessionTrackingModeType;

public class SessionConfigMetaDataParser
extends MetaDataElementParser {
    public static SessionConfigMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        SessionConfigMetaData sessionConfig = new SessionConfigMetaData();
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    sessionConfig.setId(value);
                    continue block10;
                }
                default: {
                    throw SessionConfigMetaDataParser.unexpectedAttribute(reader, i);
                }
            }
        }
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SESSION_TIMEOUT: {
                    try {
                        sessionConfig.setSessionTimeout(Integer.valueOf(reader.getElementText()).intValue());
                        continue block11;
                    }
                    catch (NumberFormatException e) {
                        throw SessionConfigMetaDataParser.unexpectedValue(reader, e);
                    }
                }
                case COOKIE_CONFIG: {
                    sessionConfig.setCookieConfig(CookieConfigMetaDataParser.parse(reader));
                    continue block11;
                }
                case TRACKING_MODE: {
                    ArrayList<SessionTrackingModeType> trackingModes = sessionConfig.getSessionTrackingModes();
                    if (trackingModes == null) {
                        trackingModes = new ArrayList<SessionTrackingModeType>();
                        sessionConfig.setSessionTrackingModes(trackingModes);
                    }
                    trackingModes.add(SessionTrackingModeType.valueOf((String)reader.getElementText()));
                    continue block11;
                }
            }
            throw SessionConfigMetaDataParser.unexpectedElement(reader);
        }
        return sessionConfig;
    }
}

