/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations;

import java.util.ArrayList;
import java.util.ListIterator;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.operations.DomainOperationTransformer;
import org.jboss.dmr.ModelNode;

public class CompositeOperationAwareTransformer
implements DomainOperationTransformer {
    private final ModelNode newOperation;

    public CompositeOperationAwareTransformer(ModelNode newOperation) {
        this.newOperation = newOperation;
    }

    @Override
    public ModelNode transform(OperationContext context, ModelNode operation) {
        if (operation.get("operation").asString().equals("composite")) {
            ModelNode ret = operation.clone();
            ArrayList<ModelNode> list = new ArrayList<ModelNode>();
            ListIterator<ModelNode> it = ret.get("steps").asList().listIterator();
            while (it.hasNext()) {
                ModelNode subOperation = it.next();
                list.add(this.transform(context, subOperation));
            }
            ret.get("steps").set(list);
            return ret;
        }
        if (this.matches(operation, this.newOperation)) {
            return this.newOperation;
        }
        return operation;
    }

    protected boolean matches(ModelNode operation, ModelNode newOperation) {
        return operation.get("operation").equals(newOperation.get("operation")) && operation.get("address").equals(newOperation.get("address"));
    }
}

