/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.validation;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.AbstractParameterValidator;
import org.jboss.as.controller.operations.validation.AllowedValuesValidator;
import org.jboss.as.controller.operations.validation.MinMaxValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;
import org.wildfly.common.Assert;

public class ChainedParameterValidator
extends AbstractParameterValidator
implements MinMaxValidator,
AllowedValuesValidator {
    private final ParameterValidator[] validators;

    public ChainedParameterValidator(ParameterValidator ... validators) {
        Assert.checkNotNullParam("validators", validators);
        this.validators = validators;
    }

    public static ParameterValidator chain(ParameterValidator ... validators) {
        return new ChainedParameterValidator(validators);
    }

    @Override
    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        for (ParameterValidator validator : this.validators) {
            validator.validateParameter(parameterName, value);
        }
    }

    @Override
    public Long getMin() {
        Long valMin = null;
        for (ParameterValidator validator : this.validators) {
            MinMaxValidator minMax;
            Long val;
            if (!(validator instanceof MinMaxValidator) || (val = (minMax = (MinMaxValidator)((Object)validator)).getMin()) == null || valMin != null && val <= valMin) continue;
            valMin = val;
        }
        return valMin;
    }

    @Override
    public Long getMax() {
        Long valMax = null;
        for (ParameterValidator validator : this.validators) {
            MinMaxValidator minMax;
            Long val;
            if (!(validator instanceof MinMaxValidator) || (val = (minMax = (MinMaxValidator)((Object)validator)).getMax()) == null || valMax != null && val >= valMax) continue;
            valMax = val;
        }
        return valMax;
    }

    @Override
    public List<ModelNode> getAllowedValues() {
        List<ModelNode> allowed = null;
        for (ParameterValidator validator : this.validators) {
            AllowedValuesValidator avv;
            List<ModelNode> val;
            if (!(validator instanceof AllowedValuesValidator) || (val = (avv = (AllowedValuesValidator)((Object)validator)).getAllowedValues()) == null) continue;
            if (allowed == null) {
                allowed = val;
                continue;
            }
            ArrayList<ModelNode> copy = new ArrayList<ModelNode>();
            for (ModelNode existing : allowed) {
                if (!val.contains(existing)) continue;
                copy.add(existing);
            }
            allowed = copy;
        }
        return allowed;
    }
}

